/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.flow.container.AbstractContainer;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.source.GlobalSource;
import java.util.Enumeration;

public class MakeContainer
extends AbstractSource {
    private static final long serialVersionUID = -132045002653940359L;
    protected GlobalActorReference[] m_GlobalActors;
    protected BaseString[] m_ValueNames;
    protected AbstractContainer m_ContainerClass;
    protected Token m_OutputToken;
    protected String m_ContainerValues;

    @Override
    public String globalInfo() {
        return "Assembles a container with data obtained from global actors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("global-actor", "globalActors", new GlobalActorReference[0]);
        this.m_OptionManager.add("value-name", "valueNames", new BaseString[0]);
        this.m_OptionManager.add("container-class", "containerClass", new SequencePlotterContainer());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
        this.m_ContainerValues = null;
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("containerClass");
        if (variable != null) {
            return variable;
        }
        return this.m_ContainerClass.getClass().getName();
    }

    public void setGlobalActors(GlobalActorReference[] value) {
        this.m_GlobalActors = value;
        this.m_ValueNames = (BaseString[])Utils.adjustArray(this.m_ValueNames, this.m_GlobalActors.length, new BaseString("unknown"));
        this.reset();
    }

    public GlobalActorReference[] getGlobalActors() {
        return this.m_GlobalActors;
    }

    public String globalActorsTipText() {
        return "The global actors to obtain the data from.";
    }

    public void setValueNames(BaseString[] value) {
        this.m_ValueNames = value;
        this.m_GlobalActors = (GlobalActorReference[])Utils.adjustArray(this.m_GlobalActors, this.m_ValueNames.length, new GlobalActorReference("unknown"));
        this.reset();
    }

    public BaseString[] getValueNames() {
        return this.m_ValueNames;
    }

    public String valueNamesTipText() {
        String values = this.getContainerValues();
        if (values != null) {
            values = values.replace(",", ", ");
        }
        return "The names to use for storing the values in the container" + (values == null ? "" : ":" + values) + ".";
    }

    public void setContainerClass(AbstractContainer value) {
        this.m_ContainerClass = value;
        this.reset();
    }

    public AbstractContainer getContainerClass() {
        return this.m_ContainerClass;
    }

    public String containerClassTipText() {
        return "The container class to generate (full class name).";
    }

    @Override
    public Class[] generates() {
        AbstractContainer cont = this.m_ContainerClass.getClone();
        if (cont != null) {
            return new Class[]{cont.getClass()};
        }
        return new Class[]{Object.class};
    }

    protected synchronized String getContainerValues() {
        if (this.m_ContainerValues == null) {
            this.m_ContainerValues = "";
            Enumeration<String> names = this.m_ContainerClass.names();
            while (names.hasMoreElements()) {
                if (this.m_ContainerValues.length() > 0) {
                    this.m_ContainerValues = this.m_ContainerValues + ",";
                }
                this.m_ContainerValues = this.m_ContainerValues + names.nextElement();
            }
        }
        return this.m_ContainerValues;
    }

    protected Object getValue(GlobalActorReference name) {
        Object result = null;
        GlobalSource global = new GlobalSource();
        global.setGlobalName(name);
        global.setParent(this.getParent());
        if (global.setUp() == null) {
            global.execute();
            Token token = global.output();
            if (token != null) {
                result = token.getPayload();
                AbstractActor actor = global.getGlobalActor();
                global.wrapUp();
                global.cleanUp();
                if (actor != null) {
                    actor.setUp();
                }
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        AbstractContainer cont = this.getContainerClass().getClone();
        for (int i = 0; i < this.m_GlobalActors.length; ++i) {
            Object value = this.getValue(this.m_GlobalActors[i]);
            cont.setValue(this.m_ValueNames[i].getValue(), value);
        }
        if (cont.isValid()) {
            this.m_OutputToken = new Token(cont);
        }
        return result;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

