/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class MakeDir
extends AbstractTransformer {
    private static final long serialVersionUID = 6057852784860612379L;

    @Override
    public String globalInfo() {
        return "Creates the directory accepted on the input port if not already existing. The actor automatically creates all missing directories in the directory hierarchy.\nJust passes the input token through, if successful.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            PlaceholderFile dir = this.m_InputToken.getPayload() instanceof File ? new PlaceholderFile((File)this.m_InputToken.getPayload()) : new PlaceholderFile((String)this.m_InputToken.getPayload());
            this.debug("Directory '" + dir + "' exists: " + ((File)dir).exists());
            if (!((File)dir).exists() && !dir.mkdirs()) {
                String string = "Error creating directory '" + dir + "'!";
            }
            result = null;
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        return result;
    }
}

