/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.visualization.core.AbstractColorGradientGenerator;
import java.awt.Color;

public class BiColorGenerator
extends AbstractColorGradientGenerator {
    private static final long serialVersionUID = 3344443413467944112L;
    protected int m_NumColors;
    protected Color m_FirstColor;
    protected Color m_SecondColor;

    @Override
    public String globalInfo() {
        return "Generates gradient colors between two colors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-colors", "numColors", 255, 1, null);
        this.m_OptionManager.add("first-color", "firstColor", Color.BLACK);
        this.m_OptionManager.add("second-color", "secondColor", Color.WHITE);
    }

    public void setNumColors(int value) {
        this.m_NumColors = value;
        this.reset();
    }

    public int getNumColors() {
        return this.m_NumColors;
    }

    public String numColorsTipText() {
        return "The number of colors in the gradient to use.";
    }

    public void setFirstColor(Color value) {
        this.m_FirstColor = value;
        this.reset();
    }

    public Color getFirstColor() {
        return this.m_FirstColor;
    }

    public String firstColorTipText() {
        return "The first color of the gradient.";
    }

    public void setSecondColor(Color value) {
        this.m_SecondColor = value;
        this.reset();
    }

    public Color getSecondColor() {
        return this.m_SecondColor;
    }

    public String secondColorTipText() {
        return "The second color of the gradient.";
    }

    @Override
    protected void check() {
        super.check();
        if (this.m_FirstColor.equals(this.m_SecondColor)) {
            throw new IllegalStateException("The two colors must be different!");
        }
    }

    @Override
    protected Color[] doGenerate() {
        Color[] result = new Color[this.m_NumColors];
        int red1 = this.m_FirstColor.getRed();
        int green1 = this.m_FirstColor.getGreen();
        int blue1 = this.m_FirstColor.getBlue();
        int red2 = this.m_SecondColor.getRed();
        int green2 = this.m_SecondColor.getGreen();
        int blue2 = this.m_SecondColor.getBlue();
        double step = 1.0 / (double)this.m_NumColors;
        for (int i = 0; i < this.m_NumColors; ++i) {
            int redNew = (int)((double)red1 + (double)(red2 < red1 ? -i : i) * step * (double)Math.abs(red2 - red1));
            int greenNew = (int)((double)green1 + (double)(green2 < green1 ? -i : i) * step * (double)Math.abs(green2 - green1));
            int blueNew = (int)((double)blue1 + (double)(blue2 < blue1 ? -i : i) * step * (double)Math.abs(blue2 - blue1));
            result[i] = new Color(redNew, greenNew, blueNew);
        }
        return result;
    }
}

