/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.DelegatingLocatorLookup;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorBasedLookup;
import java.io.File;
import java.util.StringTokenizer;

public class SearchPathLocatorLookup
extends DelegatingLocatorLookup {
    public static final String PATH_SEPARATOR = ";";

    protected void addSearchPath(File parent, String path) {
        ILocator locator;
        File child = new File(path);
        if (child.isAbsolute() || parent == null) {
            locator = new FileLocator(child);
            locator.setSynchSynchronous(true);
        } else {
            FileLocator parentLocator = new FileLocator(parent);
            parentLocator.setSynchSynchronous(true);
            locator = parentLocator.getChild(path);
        }
        this.addLocatorFactory(new LocatorBasedLookup(locator));
    }

    public void setSearchPath(File parent, String paths) {
        this.clear();
        StringTokenizer e = new StringTokenizer(paths, PATH_SEPARATOR);
        while (e.hasMoreElements()) {
            String path = (String)e.nextElement();
            if (path == null || path.trim().length() <= 0) continue;
            this.addSearchPath(parent, path);
        }
    }
}

