/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveInstancesWithMissingValue
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -8611897473185237907L;

    public String globalInfo() {
        return "Removes all instances that contain missing values.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(instances, instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance inst = instances.instance(i);
            boolean missing = false;
            for (int n = 0; n < inst.numAttributes(); ++n) {
                if (!inst.isMissing(n)) continue;
                missing = true;
                break;
            }
            if (!missing) {
                result.add((Instance)new DenseInstance(inst));
                continue;
            }
            if (!this.m_Debug) continue;
            System.out.println("Instance #" + (i + 1) + " contains missing value(s).");
        }
        result.compactify();
        if (this.m_Debug) {
            System.out.println("Reduction: " + instances.numInstances() + " -> " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        RemoveInstancesWithMissingValue.runFilter((Filter)new RemoveInstancesWithMissingValue(), (String[])args);
    }
}

