/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextStyle;

public class CellStyle
extends StyleStyle {
    public static final String STYLE_FAMILY = "table-cell";
    public static final StyleDesc<CellStyle> DESC = new StyleDesc<CellStyle>(CellStyle.class, XMLVersion.OD, "table-cell", "ce", "table", Arrays.asList("table:body", "table:covered-table-cell", "table:even-rows", "table:first-column", "table:first-row", "table:last-column", "table:last-row", "table:odd-columns", "table:odd-rows", "table:table-cell")){
        {
            this.getMultiRefElementsMap().putAll("table:default-cell-style-name", (String[])new String[]{"table:table-column", "table:table-row"});
        }

        @Override
        public CellStyle create(ODPackage oDPackage, Element element) {
            return new CellStyle(oDPackage, element);
        }
    };
    private SyleTableCellProperties cellProps;
    private TextStyle.SyleTextProperties textProps;
    private ParagraphStyle.SyleParagraphProperties pProps;

    public CellStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final Color getBackgroundColor() {
        return this.getTableCellProperties().getBackgroundColor();
    }

    public final SyleTableCellProperties getTableCellProperties() {
        if (this.cellProps == null) {
            this.cellProps = new SyleTableCellProperties(this);
        }
        return this.cellProps;
    }

    public final TextStyle.SyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.SyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.SyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.SyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public static class SyleTableCellProperties
    extends StyleProperties {
        private static final Pattern spacePattern = Pattern.compile(" +");

        public SyleTableCellProperties(StyleStyle styleStyle) {
            super(styleStyle, CellStyle.STYLE_FAMILY);
        }

        public final String getBorder(Side side) {
            return this.getSideAttribute(side, "border", this.getNS("fo"));
        }

        public final String[] getBorderLineWidth(Side side) {
            String string = this.getSideAttribute(side, "border-line-width", this.getElement().getNamespace("style"));
            return string == null ? null : spacePattern.split(string);
        }

        private final String getSideAttribute(Side side, String string, Namespace namespace) {
            String string2 = this.getElement().getAttributeValue(string, namespace);
            String string3 = string2 != null ? string2 : this.getElement().getAttributeValue(string + "-" + side.name().toLowerCase(), namespace);
            return string3;
        }

        public final int getRotationAngle() {
            String string = this.getElement().getAttributeValue("rotation-angle", this.getElement().getNamespace("style"));
            return string == null ? 0 : Integer.parseInt(string);
        }

        public final boolean isContentPrinted() {
            return this.parseBoolean(this.getElement().getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }

        public final boolean isContentRepeated() {
            return this.parseBoolean(this.getElement().getAttributeValue("repeat-content", this.getElement().getNamespace("style")), false);
        }

        public final boolean isShrinkToFit() {
            return this.parseBoolean(this.getElement().getAttributeValue("shrink-to-fit", this.getElement().getNamespace("style")), false);
        }
    }

    public static enum Side {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

