/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.io.PlaceholderDirectory;
import adams.flow.standalone.AbstractStandalone;

public class HadoopConfiguration
extends AbstractStandalone {
    private static final long serialVersionUID = -1959430342987913960L;
    protected PlaceholderDirectory m_Configuration;
    protected PlaceholderDirectory m_Binaries;

    public String globalInfo() {
        return "The Hadoop setup, used by other Hadoop actors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conf", "configuration", (Object)new PlaceholderDirectory("conf"));
        this.m_OptionManager.add("bin", "binaries", (Object)new PlaceholderDirectory("bin"));
    }

    public String getQuickInfo() {
        String result = "Conf: ";
        String variable = this.getOptionManager().getVariableForProperty("configuration");
        result = variable != null ? result + variable : result + this.m_Configuration;
        result = result + ", Bin: ";
        variable = this.getOptionManager().getVariableForProperty("binaries");
        result = variable != null ? result + ":" + variable : result + ":" + this.m_Binaries;
        return result;
    }

    public void setConfiguration(PlaceholderDirectory value) {
        this.m_Configuration = value;
    }

    public PlaceholderDirectory getConfiguration() {
        return this.m_Configuration;
    }

    public String configurationTipText() {
        return "The directory with the Hadoop configuration to use.";
    }

    public void setBinaries(PlaceholderDirectory value) {
        this.m_Binaries = value;
    }

    public PlaceholderDirectory getBinaries() {
        return this.m_Binaries;
    }

    public String binariesTipText() {
        return "The directory with the Hadoop binaries to use.";
    }

    protected String doExecute() {
        return null;
    }
}

