/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.data.statistics.StatUtils;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;
import weka.core.Instances;

public class ScatterPlotPanel
extends PlotPanel {
    private static final long serialVersionUID = 107298737463861170L;
    private Instances m_Instances;
    private int m_XIndex = 0;
    private int m_YIndex = 0;

    protected void initGUI() {
        super.initGUI();
        this.setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
        this.setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
        this.m_AxisLeft.setNumberFormat("#.##");
        this.m_AxisBottom.setNumberFormat("#.##");
    }

    protected void setinstances(Instances inst) {
        this.m_Instances = inst;
    }

    public void reset() {
        double[] m_DataX = this.m_Instances.attributeToDoubleArray(this.m_XIndex);
        double[] m_DataY = this.m_Instances.attributeToDoubleArray(this.m_YIndex);
        double xMin = StatUtils.min((double[])m_DataX);
        double xMax = StatUtils.max((double[])m_DataX);
        double yMin = StatUtils.min((double[])m_DataY);
        double yMax = StatUtils.max((double[])m_DataY);
        this.m_AxisLeft.setMinimum(yMin);
        this.m_AxisLeft.setMaximum(yMax);
        this.m_AxisBottom.setMinimum(xMin);
        this.m_AxisBottom.setMaximum(xMax);
        this.m_AxisLeft.setBottomMargin(0.1);
        this.m_AxisLeft.setTopMargin(0.1);
        this.m_AxisBottom.setBottomMargin(0.1);
        this.m_AxisBottom.setTopMargin(0.1);
        this.m_AxisLeft.setAxisName(this.m_Instances.attribute(this.m_YIndex).name());
        this.m_AxisBottom.setAxisName(this.m_Instances.attribute(this.m_XIndex).name());
        this.validate();
        this.repaint();
    }

    public void setX(int val) {
        this.m_XIndex = val;
        this.reset();
    }

    public void setY(int val) {
        this.m_YIndex = val;
        this.reset();
    }
}

