/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;

public class GzipUtils {
    public static final String EXTENSION = ".gz";

    public static String decompress(File archiveFile, int buffer) {
        return GzipUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.gz$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Apache compress commons", license=License.APACHE2, url="http://commons.apache.org/compress/apidocs/org/apache/commons/compress/compressors/CompressorStreamFactory.html")
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        CompressorInputStream in = null;
        OutputStream out = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            FileInputStream fis = new FileInputStream(archiveFile.getAbsolutePath());
            out = new FileOutputStream(outputFile.getAbsolutePath());
            in = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)fis);
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
            out.close();
            out = null;
            in.close();
            in = null;
        }
        catch (Exception e) {
            String msg = "Failed to decompress '" + archiveFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return GzipUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return GzipUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Apache compress commons", license=License.APACHE2, url="http://commons.apache.org/compress/apidocs/org/apache/commons/compress/compressors/CompressorStreamFactory.html")
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        FileInputStream in = null;
        CompressorOutputStream out = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            in = new FileInputStream(inputFile.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(outputFile.getAbsolutePath());
            out = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)fos);
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
            in.close();
            in = null;
            out.close();
            out = null;
            if (removeInput && !inputFile.delete()) {
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
        }
        catch (Exception e) {
            String msg = "Failed to compress '" + inputFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

