/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import lzma.streams.LzmaOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class LzmaUtils {
    public static final String EXTENSION = ".7z";

    public static String decompress(File archiveFile, int buffer) {
        return LzmaUtils.decompress(archiveFile, buffer, (File)new PlaceholderFile(archiveFile.getAbsolutePath().replaceAll("\\.7z$", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Julien Ponge", license=License.APACHE2, url="https://github.com/jponge/lzma-java/blob/master/README.md")
    public static String decompress(File archiveFile, int buffer, File outputFile) {
        LzmaInputStream in = null;
        OutputStream out = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            in = new LzmaInputStream((InputStream)new BufferedInputStream(new FileInputStream(archiveFile.getAbsolutePath())), new Decoder());
            out = new BufferedOutputStream(new FileOutputStream(outputFile.getAbsolutePath()));
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
            out.close();
            out = null;
            in.close();
            in = null;
        }
        catch (Exception e) {
            String msg = "Failed to decompress '" + archiveFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static String compress(File inputFile, int buffer) {
        return LzmaUtils.compress(inputFile, buffer, (File)new PlaceholderFile(inputFile.getAbsolutePath() + EXTENSION));
    }

    public static String compress(File inputFile, int buffer, File outputFile) {
        return LzmaUtils.compress(inputFile, buffer, outputFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MixedCopyright(copyright="Julien Ponge", license=License.APACHE2, url="https://github.com/jponge/lzma-java/blob/master/README.md")
    public static String compress(File inputFile, int buffer, File outputFile, boolean removeInput) {
        BufferedInputStream in = null;
        LzmaOutputStream out = null;
        String result = null;
        try {
            if (outputFile.exists()) {
                System.err.println("WARNING: overwriting '" + outputFile + "'!");
            }
            in = new BufferedInputStream(new FileInputStream(inputFile.getAbsolutePath()));
            out = new LzmaOutputStream.Builder((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile.getAbsolutePath()))).build();
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)buffer);
            in.close();
            in = null;
            out.close();
            out = null;
            if (removeInput && !inputFile.delete()) {
                result = "Failed to delete input file '" + inputFile + "' after successful compression!";
            }
        }
        catch (Exception e) {
            String msg = "Failed to compress '" + inputFile + "': ";
            System.err.println(msg);
            e.printStackTrace();
            result = msg + e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

