/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontAliasMap;
import de.intarsys.cwt.font.FontEnvironment;
import de.intarsys.cwt.font.FontFontMap;
import de.intarsys.cwt.font.FontMapper;
import de.intarsys.cwt.font.FontRegistry;
import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontQuery;

public class FontTools {
    public static String createCanonicalName(IFont font) {
        return FontTools.createCanonicalName(font.getFontFamilyName(), font.getFontStyle().getId());
    }

    public static String createCanonicalName(String fontFamilyName, String styleName) {
        return String.valueOf(fontFamilyName.replaceAll("\\s", "")) + "," + styleName;
    }

    public static String getFontFamilyName(String fontName) {
        if (fontName == null) {
            return null;
        }
        int posMinus = fontName.indexOf(45);
        if (posMinus > 0) {
            fontName = fontName.substring(0, posMinus);
        }
        return fontName;
    }

    public static FontStyle getFontStyle(String fontName) {
        if (fontName == null) {
            return FontStyle.REGULAR;
        }
        int posMinus = fontName.indexOf(45);
        if (posMinus > 0) {
            fontName = fontName.substring(posMinus + 1);
        }
        return FontStyle.getFontStyle(fontName);
    }

    public static IFont lookupFont(IFontQuery query) {
        IFont result = FontTools.lookupFontOrMap(query);
        if (result == null && FontEnvironment.get().registerUserFonts()) {
            result = FontTools.lookupFontOrMap(query);
        }
        if (result == null && FontEnvironment.get().registerSystemFonts()) {
            result = FontTools.lookupFontOrMap(query);
        }
        return result;
    }

    protected static IFont lookupFontOrMap(IFontQuery query) {
        IFont result = FontRegistry.get().lookupFont(query);
        if (result == null) {
            result = FontMapper.get().lookupFont(query.getFontName());
        }
        return result;
    }

    public static void mapAlias(String name, String alias) {
        FontAliasMap map = new FontAliasMap(FontMapper.get(), name, alias);
        FontMapper.get().registerFontMap(map);
    }

    public static void mapFont(String name, IFont font) {
        FontFontMap map = new FontFontMap(FontMapper.get(), name, font);
        FontMapper.get().registerFontMap(map);
    }
}

