/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.DriftDetectionMethod;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class EDDM
extends AbstractOptionHandler
implements DriftDetectionMethod {
    private static final long serialVersionUID = 140980267062162000L;
    private static final double FDDM_OUTCONTROL = 0.9;
    private static final double FDDM_WARNING = 0.95;
    private static final double FDDM_MINNUMINSTANCES = 30.0;
    private double m_numErrors;
    private int m_minNumErrors = 30;
    private int m_n;
    private int m_d;
    private int m_lastd;
    private double m_mean;
    private double m_stdTemp;
    private double m_m2smax;
    private int m_lastLevel;

    public EDDM() {
        this.initialize();
    }

    private void initialize() {
        this.m_n = 1;
        this.m_numErrors = 0.0;
        this.m_d = 0;
        this.m_lastd = 0;
        this.m_mean = 0.0;
        this.m_stdTemp = 0.0;
        this.m_m2smax = 0.0;
        this.m_lastLevel = 0;
    }

    public int computeNextVal(boolean prediction) {
        ++this.m_n;
        if (!prediction) {
            this.m_numErrors += 1.0;
            this.m_lastd = this.m_d;
            this.m_d = this.m_n - 1;
            int distance = this.m_d - this.m_lastd;
            double oldmean = this.m_mean;
            this.m_mean += ((double)distance - this.m_mean) / this.m_numErrors;
            this.m_stdTemp += ((double)distance - this.m_mean) * ((double)distance - oldmean);
            double std = Math.sqrt(this.m_stdTemp / this.m_numErrors);
            double m2s = this.m_mean + 2.0 * std;
            if (m2s > this.m_m2smax) {
                if ((double)this.m_n > 30.0) {
                    this.m_m2smax = m2s;
                }
                this.m_lastLevel = 0;
            } else {
                double p = m2s / this.m_m2smax;
                if ((double)this.m_n > 30.0 && this.m_numErrors > (double)this.m_minNumErrors && p < 0.9) {
                    System.out.println(this.m_mean + ",D");
                    this.initialize();
                    return 2;
                }
                if ((double)this.m_n > 30.0 && this.m_numErrors > (double)this.m_minNumErrors && p < 0.95) {
                    System.out.println(this.m_mean + ",W");
                    this.m_lastLevel = 1;
                    return 1;
                }
                System.out.println(this.m_mean + ",N");
                this.m_lastLevel = 0;
                return 0;
            }
        }
        return this.m_lastLevel;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    public DriftDetectionMethod copy() {
        return (DriftDetectionMethod)super.copy();
    }
}

