/*
 * Decompiled with CFR 0.152.
 */
package adams.data.container;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;

public abstract class AbstractDataPoint
implements DataPoint {
    private static final long serialVersionUID = -7649691865561959944L;
    protected DataContainer m_Parent;

    @Override
    public void setParent(DataContainer value) {
        this.m_Parent = value;
    }

    @Override
    public DataContainer getParent() {
        return this.m_Parent;
    }

    @Override
    public boolean hasParent() {
        return this.m_Parent != null;
    }

    public abstract int compareTo(Object var1);

    public boolean equals(Object obj) {
        if (obj instanceof DataPoint) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    @Override
    public Object getClone() {
        if (this.m_Parent == null) {
            throw new IllegalStateException("Need parent for getClone() - use manual duplication of data point!");
        }
        Object result = this.m_Parent.newPoint();
        result.assign(this);
        result.setParent(null);
        return result;
    }

    @Override
    public void assign(DataPoint other) {
        this.setParent(other.getParent());
    }

    public abstract String toString();

    public static Double toDouble(Object value) {
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        return null;
    }

    public static Double toDouble(Number value) {
        return new Double(value.doubleValue());
    }

    public static Double toDouble(Byte value) {
        return new Double(value.doubleValue());
    }

    public static Double toDouble(Short value) {
        return new Double(value.doubleValue());
    }

    public static Double toDouble(Integer value) {
        return new Double(value.doubleValue());
    }

    public static Double toDouble(Long value) {
        return new Double(value.doubleValue());
    }

    public static Double toDouble(Float value) {
        return new Double(value.doubleValue());
    }

    public static Double toDouble(Double value) {
        return new Double(value);
    }
}

