/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.ConsoleObject;
import adams.core.Properties;
import adams.data.sequence.XYSequence;
import adams.db.SequenceProvider;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Sequences
extends ConsoleObject
implements SequenceProvider {
    private static final long serialVersionUID = -6223247854964334340L;
    public static final String FILENAME = "Sequences.props";
    public static final String PREFIX_TEMPLATE = "Template.";
    protected Properties m_Properties;

    protected Sequences() {
        this.refresh();
    }

    @Override
    public abstract void refresh();

    protected boolean isTypeNumeric(int type) {
        boolean result = type == -5 || type == -7 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7 || type == 5 || type == -6;
        return result;
    }

    protected boolean isTypeDate(int type) {
        boolean result = type == 91 || type == 92 || type == 93;
        return result;
    }

    protected int findColumn(ResultSet rs, String colName, boolean numeric) {
        int result = -1;
        colName = colName.toLowerCase();
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int count = meta.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String name = meta.getColumnName(i).toLowerCase();
                String label = meta.getColumnLabel(i).toLowerCase();
                int type = meta.getColumnType(i);
                if (!name.equals(colName) && !label.equals(colName) || numeric && !this.isTypeNumeric(type) && !this.isTypeDate(type)) continue;
                result = i;
                break;
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    protected Hashtable<Integer, Integer> filterColumns(ResultSet rs) {
        Hashtable<Integer, Integer> result = new Hashtable<Integer, Integer>();
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int count = meta.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                int type = meta.getColumnType(i);
                if (this.isTypeNumeric(type)) {
                    result.put(i, 8);
                    continue;
                }
                if (!this.isTypeDate(type)) continue;
                result.put(i, type);
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    protected String getColumnName(ResultSet rs, int index) {
        String result = null;
        try {
            ResultSetMetaData meta = rs.getMetaData();
            result = meta.getColumnLabel(index);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    protected double getValue(ResultSet rs, int index, int type) {
        double result = -1.0;
        try {
            result = type == 4 ? (double)rs.getInt(index) : (type == 91 ? (double)rs.getDate(index).getTime() : (type == 92 ? (double)rs.getTime(index).getTime() : (type == 93 ? (double)rs.getTimestamp(index).getTime() : rs.getDouble(index))));
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    public Vector<XYSequence> retrieve(String query) {
        return this.retrieve(query, null);
    }

    @Override
    public abstract Vector<XYSequence> retrieve(String var1, String var2);

    @Override
    public Hashtable<String, String> getTemplates() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration<?> names = this.m_Properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(PREFIX_TEMPLATE)) continue;
            result.put(name.substring(PREFIX_TEMPLATE.length()).replaceAll("_", " "), this.m_Properties.getProperty(name, ""));
        }
        return result;
    }
}

