/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.io.FlowFile;
import adams.event.VariableChangeEvent;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import java.util.Vector;

public abstract class AbstractExternalActor
extends AbstractActor {
    private static final long serialVersionUID = 1024129351334661368L;
    protected FlowFile m_ActorFile;
    protected AbstractActor m_ExternalActor;
    protected Boolean m_ActorFileIsVariable;
    protected String m_ActorFileVariable;
    protected boolean m_ActorFileChanged;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "actorFile", new FlowFile("."));
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("actorFile");
        if (variable != null) {
            return variable;
        }
        if (this.m_ActorFile != null) {
            return this.m_ActorFile.toString();
        }
        return null;
    }

    public void setActorFile(FlowFile value) {
        this.m_ActorFile = value;
        this.reset();
    }

    public FlowFile getActorFile() {
        return this.m_ActorFile;
    }

    public String actorFileTipText() {
        return "The file containing the external actor.";
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if (this.m_ActorFileIsVariable == null) {
            this.m_ActorFileVariable = this.getOptionManager().getVariableForProperty("actorFile");
            this.m_ActorFileIsVariable = this.m_ActorFileVariable != null;
            if (this.m_ActorFileIsVariable != null) {
                this.m_ActorFileVariable = Variables.extractName(this.m_ActorFileVariable);
            }
        }
        if (this.m_ActorFileIsVariable.booleanValue() && e.getName().equals(this.m_ActorFileVariable)) {
            this.m_ActorFileChanged = e.getType() != VariableChangeEvent.Type.REMOVED;
        }
    }

    public AbstractActor getExternalActor() {
        return this.m_ExternalActor;
    }

    protected void cleanUpExternalActor() {
        if (this.m_ActorFileChanged && this.m_ExternalActor != null) {
            this.m_ExternalActor.wrapUp();
            this.m_ExternalActor.cleanUp();
            this.m_ExternalActor = null;
        }
    }

    protected String setUpExternalActor() {
        String result = null;
        if (!this.m_ActorFile.isFile()) {
            result = "'" + this.m_ActorFile.getAbsolutePath() + "' does not point to a file!";
        } else {
            Vector<String> errors = new Vector<String>();
            this.m_ExternalActor = ActorUtils.read(this.m_ActorFile.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Error loading external actor '" + this.m_ActorFile.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n");
            } else if (this.m_ExternalActor == null) {
                result = "Error loading external actor '" + this.m_ActorFile.getAbsolutePath() + "'!";
            } else {
                this.m_ExternalActor.setParent(this);
                this.m_ExternalActor.setHeadless(this.isHeadless());
                result = this.m_ExternalActor.setUp();
            }
        }
        this.m_ActorFileChanged = false;
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.cleanUpExternalActor();
            if (this.getOptionManager().getVariableForProperty("actorFile") == null && this.m_ExternalActor == null) {
                result = this.setUpExternalActor();
            }
        }
        return result;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        if (this.m_ExternalActor != null) {
            this.m_ExternalActor.stopExecution();
        }
    }

    protected String preExecuteExternalActorHook() {
        return null;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.cleanUpExternalActor();
        if (this.m_ExternalActor == null) {
            result = this.setUpExternalActor();
        }
        if (result == null) {
            result = this.preExecuteExternalActorHook();
        }
        if (result == null) {
            result = this.m_ExternalActor.execute();
        }
        return result;
    }

    @Override
    public void wrapUp() {
        if (this.m_ExternalActor != null) {
            this.m_ExternalActor.wrapUp();
        }
        this.m_ActorFileIsVariable = null;
        this.m_ActorFileVariable = null;
        this.m_ActorFileChanged = false;
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_ExternalActor != null) {
            this.m_ExternalActor.destroy();
            this.m_ExternalActor.setParent(null);
            this.m_ExternalActor = null;
        }
        super.cleanUp();
    }
}

