/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.processor.AbstractModifyingProcessor;
import java.lang.reflect.Method;

public class ManageInteractiveActors
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = -3520719602643255362L;
    protected boolean m_Enable;

    @Override
    public String globalInfo() {
        return "Enables/disables the interactive behaviour of " + AutomatableInteractiveActor.class.getName() + " actors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("enable", "enable", true);
    }

    public void setEnable(boolean value) {
        this.m_Enable = value;
        this.reset();
    }

    public boolean getEnable() {
        return this.m_Enable;
    }

    public String enableTipText() {
        return "If enabled, the interactive behaviour of actors will get enabled.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            @Override
            public void handleClassOption(ClassOption option) {
            }

            @Override
            public void handleBooleanOption(BooleanOption option) {
                if (option.getOptionHandler() instanceof AutomatableInteractiveActor && option.getProperty().equals("nonInteractive")) {
                    Method method = option.getDescriptor().getWriteMethod();
                    try {
                        method.invoke((Object)option.getOptionHandler(), ManageInteractiveActors.this.m_Enable);
                        ManageInteractiveActors.this.m_Modified = true;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to update " + option + ": ");
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option) {
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }
        });
        if (this.m_Modified) {
            this.m_ModifiedActor = actor;
        }
    }
}

