/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.flow.sink.sequenceplotter.MarkerPaintlet;
import adams.flow.sink.sequenceplotter.VerticalMarkers;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.util.Vector;

public class SequencePlotterPanel
extends XYSequencePanel {
    private static final long serialVersionUID = -325993535017871634L;
    protected MarkerPaintlet m_MarkerPaintlet;
    protected XYSequenceContainerManager m_MarkerContainerManager;

    public SequencePlotterPanel(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_MarkerContainerManager = this.newMarkerContainerManager();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_MarkerPaintlet = new VerticalMarkers();
        this.m_MarkerPaintlet.setPanel(this);
        this.setAllowResize(true);
    }

    protected XYSequenceContainerManager newMarkerContainerManager() {
        XYSequenceContainerManager result = new XYSequenceContainerManager(this);
        result.removeDataChangeListener(this);
        return result;
    }

    public XYSequenceContainerManager getMarkerContainerManager() {
        return this.m_MarkerContainerManager;
    }

    public void setMarkerPaintlet(MarkerPaintlet value) {
        this.m_MarkerPaintlet.setPanel(null);
        this.m_MarkerPaintlet = value;
        this.m_MarkerPaintlet.setPanel(this);
        this.reset();
    }

    public MarkerPaintlet getMarkerPaintlet() {
        return this.m_MarkerPaintlet;
    }

    public void setColorProvider(AbstractColorProvider value) {
        ((XYSequenceContainerManager)this.getContainerManager()).setColorProvider(value.shallowCopy(true));
        this.getMarkerContainerManager().setColorProvider(this.getColorProvider().shallowCopy(true));
    }

    public AbstractColorProvider getColorProvider() {
        return ((XYSequenceContainerManager)this.getContainerManager()).getColorProvider();
    }

    protected int[] toMarkerIndices(int[] seqIndices) {
        int i;
        Vector<Integer> markerIndices = new Vector<Integer>();
        XYSequenceContainerManager markerManager = this.getMarkerContainerManager();
        XYSequenceContainerManager seqManager = (XYSequenceContainerManager)this.getContainerManager();
        for (i = 0; i < seqIndices.length; ++i) {
            String id = ((XYSequenceContainer)seqManager.get(seqIndices[i])).getID();
            int index = markerManager.indexOf(id);
            if (index == -1) continue;
            markerIndices.add(index);
        }
        int[] result = new int[markerIndices.size()];
        for (i = 0; i < markerIndices.size(); ++i) {
            result[i] = (Integer)markerIndices.get(i);
        }
        return result;
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        switch (e.getType()) {
            case CLEAR: {
                this.getMarkerContainerManager().clear();
                break;
            }
            case REMOVAL: {
                int[] indices = this.toMarkerIndices(e.getIndices());
                for (int i = indices.length - 1; i >= 0; --i) {
                    this.getMarkerContainerManager().remove(indices[i]);
                }
                break;
            }
            case VISIBILITY: {
                int[] indices = this.toMarkerIndices(e.getIndices());
                for (int i = 0; i < indices.length; ++i) {
                    this.getMarkerContainerManager().setVisible(indices[i], ((XYSequenceContainerManager)this.getContainerManager()).isVisible(indices[i]));
                }
                break;
            }
            case BULK_UPDATE: {
                int i = 0;
                while (i < this.getMarkerContainerManager().count()) {
                    if (((XYSequenceContainerManager)this.getContainerManager()).indexOf(((XYSequenceContainer)this.getMarkerContainerManager().get(i)).getID()) == -1) {
                        this.getMarkerContainerManager().remove(i);
                        continue;
                    }
                    ++i;
                }
                break;
            }
        }
        super.dataChanged(e);
    }
}

