/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.db.AbstractConditions;
import adams.db.AbstractLimitedConditions;
import adams.flow.source.AbstractDatabaseIdSupplier;
import adams.flow.source.ConditionalIdSupplier;

public abstract class AbstractConditionalIdSupplier
extends AbstractDatabaseIdSupplier
implements ConditionalIdSupplier {
    private static final long serialVersionUID = -8462709950859959951L;
    protected AbstractConditions m_Conditions;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conditions", "conditions", this.getDefaultConditions());
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + ", using " + this.getConditions().getClass().getName().replaceFirst("^.*\\.db\\.", "");
        if (this.m_Conditions instanceof AbstractLimitedConditions) {
            int limit;
            String variable = ((AbstractLimitedConditions)this.m_Conditions).getOptionManager().getVariableForProperty("limit");
            result = variable != null ? result + ", max: " + variable : ((limit = ((AbstractLimitedConditions)this.m_Conditions).getLimit()) == -1 ? result + ", unlimited" : result + ", max: " + limit);
        }
        return result;
    }

    protected abstract AbstractConditions getDefaultConditions();

    protected Class[] getAcceptedConditions() {
        return new Class[]{this.getDefaultConditions().getClass()};
    }

    @Override
    public void setConditions(AbstractConditions value) {
        int i;
        Class[] classes = this.getAcceptedConditions();
        boolean found = false;
        for (i = 0; i < classes.length; ++i) {
            if (!classes[i].isInstance(value)) continue;
            found = true;
            this.m_Conditions = value;
            this.reset();
        }
        if (!found) {
            String classesStr = "";
            for (i = 0; i < classes.length; ++i) {
                if (i > 0) {
                    classesStr = classesStr + ", ";
                }
                classesStr = classesStr + classes[i].getName();
            }
            this.getSystemErr().println("Only the folloing container(s) are allowed: " + classesStr);
        }
    }

    @Override
    public AbstractConditions getConditions() {
        return this.m_Conditions;
    }

    @Override
    public String conditionsTipText() {
        return "The conditions for retrieving the data from the database.";
    }
}

