/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class MatchReportFields
extends AbstractTransformer {
    private static final long serialVersionUID = -6237324482439105653L;
    public static final String BACKUP_QUEUE = "queue";
    protected BaseRegExp m_RegExp;
    protected ArrayList<AbstractField> m_Queue;

    @Override
    public String globalInfo() {
        return "Outputs all fields that match the regular expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", this.getDefaultRegularExpression());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("regExp");
        String result = variable != null ? variable : this.m_RegExp.getValue();
        return result;
    }

    protected BaseRegExp getDefaultRegularExpression() {
        return new BaseRegExp(".*");
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match against the field names.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_QUEUE, this.m_Queue);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (ArrayList)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{AbstractField.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Report report = this.m_InputToken.getPayload() instanceof ReportHandler ? ((ReportHandler)this.m_InputToken.getPayload()).getReport() : (Report)this.m_InputToken.getPayload();
        this.m_Queue.clear();
        Vector<AbstractField> fields = report.getFields();
        for (AbstractField field : fields) {
            if (!this.m_RegExp.isMatch(field.getName())) continue;
            this.m_Queue.add(field);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }
}

