/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.env.Environment;
import adams.gui.chooser.FontChooserPanel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontChooser
extends BaseDialog {
    private static final long serialVersionUID = 4228582248866956387L;
    protected FontChooserPanel m_FontPanel;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;
    protected Font m_Current;

    public FontChooser(Frame owner) {
        super(owner, "Font Chooser", true);
    }

    public FontChooser(Dialog owner) {
        super(owner, "Font Chooser", Dialog.ModalityType.DOCUMENT_MODAL);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.getContentPane().setLayout(new BorderLayout());
        this.m_FontPanel = new FontChooserPanel();
        this.getContentPane().add((Component)this.m_FontPanel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        panelButtons.add(this.m_ButtonOK);
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.m_Current = FontChooser.this.m_FontPanel.getCurrent();
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        this.m_ButtonCancel = new JButton("Cancel");
        this.m_ButtonCancel.setMnemonic('C');
        panelButtons.add(this.m_ButtonCancel);
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.m_FontPanel.setCurrent(FontChooser.this.m_Current);
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)panelButtons, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setCurrent(Font value) {
        this.m_Current = value;
        this.m_FontPanel.setCurrent(this.m_Current);
    }

    public Font getCurrent() {
        return this.m_Current;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        final BaseFrame frame = new BaseFrame("FontChooser Startup");
        final FontChooser chooser = new FontChooser(frame);
        chooser.setCurrent(null);
        frame.getContentPane().setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Change font");
        frame.getContentPane().add(button);
        final JLabel label = new JLabel("Java is great!", 0);
        label.setFont(chooser.getCurrent());
        frame.getContentPane().add(label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setVisible(true);
                Font myNewFont = chooser.getCurrent();
                System.out.println("You chose " + myNewFont);
                label.setFont(myNewFont);
                frame.pack();
                chooser.dispose();
            }
        });
        frame.setSize(150, 100);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

