/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.AbstractComponentWithButtons;
import adams.gui.core.MouseUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public abstract class AbstractDoubleClickableComponentWithButtons<T extends Component>
extends AbstractComponentWithButtons<T> {
    private static final long serialVersionUID = 5421965370098048279L;
    protected JButton m_DoubleClickButton;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick(e) && AbstractDoubleClickableComponentWithButtons.this.m_DoubleClickButton != null) {
                    if (AbstractDoubleClickableComponentWithButtons.this.isValidDoubleClick(e)) {
                        e.consume();
                        AbstractDoubleClickableComponentWithButtons.this.m_DoubleClickButton.doClick();
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    protected abstract boolean isValidDoubleClick(MouseEvent var1);

    public void setDoubleClickButton(JButton value) {
        this.m_DoubleClickButton = value;
    }

    public JButton getDoubleClickButton() {
        return this.m_DoubleClickButton;
    }
}

