/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.AbstractBaseTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class ResultSetTableModel
extends AbstractBaseTableModel {
    private static final long serialVersionUID = 3381325114377596348L;
    protected String[] m_Columns;
    protected Hashtable<String, Integer> m_ColumnIndex;
    protected Vector<Object[]> m_Data;

    public ResultSetTableModel(String[] columns) {
        this.m_Columns = (String[])columns.clone();
        this.m_Data = new Vector();
        this.initialize();
    }

    public ResultSetTableModel(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        this.m_Columns = new String[meta.getColumnCount()];
        for (i = 0; i < this.m_Columns.length; ++i) {
            this.m_Columns[i] = meta.getColumnName(i + 1);
        }
        this.m_Data = new Vector();
        while (rs.next()) {
            Object[] row = new Object[this.m_Columns.length];
            for (i = 0; i < row.length; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            this.m_Data.add(row);
        }
        this.initialize();
    }

    protected void initialize() {
        this.m_ColumnIndex = new Hashtable();
        for (int i = 0; i < this.m_Columns.length; ++i) {
            this.m_ColumnIndex.put(this.m_Columns[i].toLowerCase(), i);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_Data.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.m_Columns[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.m_Columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.m_Data.get(rowIndex)[columnIndex];
    }

    public int getColumnIndex(String columnName) {
        Integer result = this.m_ColumnIndex.get(columnName.toLowerCase());
        if (result == null) {
            return -1;
        }
        return result;
    }

    public Object getValueAt(int rowIndex, String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        if (columnIndex == -1) {
            return null;
        }
        return this.getValueAt(rowIndex, columnIndex);
    }
}

