/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import java.awt.geom.Rectangle2D;

public class CSTextSearchHit {
    private StringBuilder buffer = new StringBuilder();
    private Rectangle2D rect;
    private String prefix;
    private String suffix;

    public void add(char c, Rectangle2D charRect) {
        this.buffer.append(c);
        if (this.rect == null) {
            this.rect = (Rectangle2D)charRect.clone();
        } else {
            this.rect.add(charRect);
        }
    }

    public String getLabel() {
        return String.valueOf(this.getTrimmedPrefix()) + this.getText() + this.getSuffix() + "...";
    }

    public Rectangle2D getRect() {
        return this.rect;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getText() {
        return this.buffer.toString();
    }

    private String getTrimmedPrefix() {
        int i = this.prefix.length() - 1;
        while (i > 0) {
            char c = this.prefix.charAt(i);
            if (Character.isWhitespace(c) && this.prefix.length() - i >= 5) {
                ++i;
                break;
            }
            --i;
        }
        return this.prefix.substring(i);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

