/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

public class COSObjectKey {
    private final int objectNumber;
    private final short generationNumber;

    public COSObjectKey(int objectNumber, int generationNumber) {
        this.objectNumber = objectNumber;
        this.generationNumber = (short)generationNumber;
    }

    public COSObjectKey createNextKey() {
        return new COSObjectKey(this.getObjectNumber() + 1, 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof COSObjectKey)) {
            return false;
        }
        COSObjectKey other = (COSObjectKey)obj;
        return this.objectNumber == other.objectNumber;
    }

    public int getGenerationNumber() {
        return this.generationNumber & 0xFFFF;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int hashCode() {
        return this.objectNumber;
    }

    public String toString() {
        return String.valueOf(this.getObjectNumber()) + " " + this.getGenerationNumber() + " R";
    }
}

