/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;
import java.util.Iterator;

public class XRefStreamWriter
extends AbstractXRefWriter {
    public static byte[] TYPE_FREE = new byte[1];
    public static byte[] TYPE_OCCUPIED = new byte[]{1};
    public static byte[] TYPE_COMPRESSED = new byte[]{2};
    private int[] wSize;

    public XRefStreamWriter(COSWriter cosWriter) {
        super(cosWriter);
    }

    private int byteSizeOf(int number) {
        int mask = -16777216;
        int size = 4;
        while (size > 0) {
            if ((number & mask) != 0) {
                return size;
            }
            mask >>= 8;
            --size;
        }
        return 0;
    }

    protected void finish(STXRefSection xRefSection) throws IOException {
        byte[] innerBytes = ((RandomAccessByteArray)this.getRandomAccess()).toByteArray();
        ((STStreamXRefSection)xRefSection).cosGetStream().setDecodedBytes(innerBytes);
        this.getCosWriter().writeIndirectObject(((STStreamXRefSection)xRefSection).cosGetStream().getIndirectObject());
        super.finish(xRefSection);
    }

    protected byte[] getTypeCompressed() {
        return TYPE_COMPRESSED;
    }

    protected byte[] getTypeFree() {
        return TYPE_FREE;
    }

    protected byte[] getTypeOccupied() {
        return TYPE_OCCUPIED;
    }

    protected void initialize(STXRefSection xRefSection) throws IOException {
        super.initialize(xRefSection);
        STStreamXRefSection xrefStream = (STStreamXRefSection)xRefSection;
        this.setRandomAccess((IRandomAccess)new RandomAccessByteArray(null));
        this.initWSize(xrefStream);
        xrefStream.setIndex(COSArray.create());
        COSIndirectObject io = xrefStream.cosGetStream().getIndirectObject();
        int objectNumber = io.getObjectNumber();
        int generationNumber = io.getGenerationNumber();
        if (objectNumber == -1) {
            int size;
            objectNumber = size = xrefStream.getSize();
            generationNumber = 0;
            xrefStream.cosGetStream().getIndirectObject().setKey(objectNumber, generationNumber);
            xrefStream.setSize(size + 1);
        }
        xRefSection.addEntry(new STXRefEntryOccupied(objectNumber, generationNumber, xRefSection.getOffset()));
    }

    private void initWSize(STXRefSection xRefSection) {
        SearchVisitor search = new SearchVisitor();
        Iterator i = xRefSection.entryIterator();
        while (i.hasNext()) {
            STXRefEntry entry = (STXRefEntry)i.next();
            try {
                entry.accept(search);
            }
            catch (XRefEntryVisitorException xRefEntryVisitorException) {
                // empty catch block
            }
        }
        this.wSize = new int[3];
        this.wSize[0] = 1;
        this.wSize[1] = this.byteSizeOf((int)search.getHighestOffset());
        this.wSize[2] = this.byteSizeOf(search.getHighestGeneration());
        COSArray wArray = COSArray.create(3);
        int i2 = 0;
        while (i2 < 3) {
            wArray.add(COSInteger.create(this.wSize[i2]));
            ++i2;
        }
        ((STStreamXRefSection)xRefSection).setW(wArray);
    }

    protected void visitFromSubsection(STXRefSubsection section) {
        COSArray index = ((STStreamXRefSection)section.getXRefSection()).getIndex();
        index.add(COSInteger.create(section.getStart()));
        index.add(COSInteger.create(section.getSize()));
    }

    private void write(int data, int numBytes) throws IOException {
        switch (numBytes) {
            case 4: {
                this.getRandomAccess().write((data & 0xFF000000) >> 24);
            }
            case 3: {
                this.getRandomAccess().write((data & 0xFF0000) >> 16);
            }
            case 2: {
                this.getRandomAccess().write((data & 0xFF00) >> 8);
            }
            case 1: {
                this.getRandomAccess().write(data & 0xFF);
            }
        }
    }

    protected void write(int col1, int col2, byte[] type) throws IOException {
        this.getRandomAccess().write(type);
        this.write(col1, this.wSize[1]);
        this.write(col2, this.wSize[2]);
    }

    class SearchVisitor
    implements IXRefEntryVisitor {
        private long highestOffset = 0L;
        private int highestGeneration = 0;

        SearchVisitor() {
        }

        private void checkGeneration(int generation) {
            if (generation > this.highestGeneration) {
                this.highestGeneration = generation;
            }
        }

        private void checkOffset(long offset) {
            if (offset > this.highestOffset) {
                this.highestOffset = offset;
            }
        }

        public int getHighestGeneration() {
            return this.highestGeneration;
        }

        public long getHighestOffset() {
            return this.highestOffset;
        }

        public void visitFromCompressed(STXRefEntryCompressed entry) {
            this.checkOffset(entry.getStreamObjectNumber());
            this.checkGeneration(entry.getIndex());
        }

        public void visitFromFree(STXRefEntryFree entry) {
            this.checkOffset(entry.getNextFreeObjectNumber());
            this.checkGeneration(entry.getGenerationNumber());
        }

        public void visitFromOccupied(STXRefEntryOccupied entry) {
            this.checkOffset(entry.getOffset());
            this.checkGeneration(entry.getGenerationNumber());
        }
    }
}

