/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp.pixelparsers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.bmp.BmpHeaderInfo;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserSimple;

public class PixelParserBitFields
extends PixelParserSimple {
    private final int redShift;
    private final int greenShift;
    private final int blueShift;
    private final int redMask;
    private final int greenMask;
    private final int blueMask;
    private int bytecount = 0;

    public PixelParserBitFields(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) throws ImageReadException, IOException {
        super(bhi, ColorTable, ImageData);
        ByteArrayInputStream bais = new ByteArrayInputStream(ColorTable);
        this.redMask = this.bfp.read4Bytes("redMask", bais, "BMP BI_BITFIELDS Bad Color Table");
        this.greenMask = this.bfp.read4Bytes("greenMask", bais, "BMP BI_BITFIELDS Bad Color Table");
        this.blueMask = this.bfp.read4Bytes("blueMask", bais, "BMP BI_BITFIELDS Bad Color Table");
        this.redShift = this.getMaskShift(this.redMask);
        this.greenShift = this.getMaskShift(this.greenMask);
        this.blueShift = this.getMaskShift(this.blueMask);
    }

    private int getMaskShift(int mask) {
        int trailingZeroes = 0;
        while ((1 & mask) == 0) {
            mask = Integer.MAX_VALUE & mask >> 1;
            ++trailingZeroes;
        }
        int maskLength = 0;
        while ((1 & mask) == 1) {
            mask = Integer.MAX_VALUE & mask >> 1;
            ++maskLength;
        }
        return trailingZeroes - (8 - maskLength);
    }

    public int getNextRGB() throws ImageReadException, IOException {
        int data;
        if (this.bhi.bitsPerPixel == 8) {
            data = 0xFF & this.imageData[this.bytecount + 0];
            ++this.bytecount;
        } else if (this.bhi.bitsPerPixel == 24) {
            data = this.bfp.read3Bytes("Pixel", this.is, "BMP Image Data");
            this.bytecount += 3;
        } else if (this.bhi.bitsPerPixel == 32) {
            data = this.bfp.read4Bytes("Pixel", this.is, "BMP Image Data");
            this.bytecount += 4;
        } else if (this.bhi.bitsPerPixel == 16) {
            data = this.bfp.read2Bytes("Pixel", this.is, "BMP Image Data");
            this.bytecount += 2;
        } else {
            throw new ImageReadException("Unknown BitsPerPixel: " + this.bhi.bitsPerPixel);
        }
        int red = this.redMask & data;
        int green = this.greenMask & data;
        int blue = this.blueMask & data;
        red = this.redShift >= 0 ? red >> this.redShift : red << -this.redShift;
        green = this.greenShift >= 0 ? green >> this.greenShift : green << -this.greenShift;
        blue = this.blueShift >= 0 ? blue >> this.blueShift : blue << -this.blueShift;
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        return rgb;
    }

    public void newline() throws ImageReadException, IOException {
        while (this.bytecount % 4 != 0) {
            this.bfp.readByte("Pixel", this.is, "BMP Image Data");
            ++this.bytecount;
        }
    }
}

