/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.jpeg.segments.APPNSegment;

public class App2Segment
extends APPNSegment
implements Comparable {
    public final byte[] icc_bytes;
    public final int cur_marker;
    public final int num_markers;

    public App2Segment(int marker, byte[] segmentData) throws ImageReadException, IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public App2Segment(int marker, int marker_length, InputStream is2) throws ImageReadException, IOException {
        super(marker, marker_length, is2);
        if (this.startsWith(this.bytes, JpegImageParser.icc_profile_label)) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.bytes);
            this.readAndVerifyBytes(is, JpegImageParser.icc_profile_label, "Not a Valid App2 Segment: missing ICC Profile label");
            this.cur_marker = this.readByte("cur_marker", is, "Not a valid App2 Marker");
            this.num_markers = this.readByte("num_markers", is, "Not a valid App2 Marker");
            marker_length -= JpegImageParser.icc_profile_label.length;
            this.icc_bytes = this.readByteArray("App2 Data", marker_length -= 2, is, "Invalid App2 Segment: insufficient data");
        } else {
            this.cur_marker = -1;
            this.num_markers = -1;
            this.icc_bytes = null;
        }
    }

    public int compareTo(Object o) {
        App2Segment other = (App2Segment)o;
        return this.cur_marker - other.cur_marker;
    }
}

