/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterBase;
import org.apache.sanselan.formats.tiff.write.TiffOutputItem;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.apache.sanselan.formats.tiff.write.TiffOutputSummary;

public class TiffImageWriterLossy
extends TiffImageWriterBase {
    public TiffImageWriterLossy() {
    }

    public TiffImageWriterLossy(int byteOrder) {
        super(byteOrder);
    }

    public void write(OutputStream os, TiffOutputSet outputSet) throws IOException, ImageWriteException {
        TiffOutputSummary outputSummary = this.validateDirectories(outputSet);
        List outputItems = outputSet.getOutputItems(outputSummary);
        this.updateOffsetsStep(outputItems);
        outputSummary.updateOffsets(this.byteOrder);
        BinaryOutputStream bos = new BinaryOutputStream(os, this.byteOrder);
        this.writeStep(bos, outputItems);
    }

    private void updateOffsetsStep(List outputItems) throws IOException, ImageWriteException {
        int offset = 8;
        for (int i = 0; i < outputItems.size(); ++i) {
            TiffOutputItem outputItem = (TiffOutputItem)outputItems.get(i);
            outputItem.setOffset(offset);
            int itemLength = outputItem.getItemLength();
            offset += itemLength;
            int remainder = TiffImageWriterLossy.imageDataPaddingLength(itemLength);
            offset += remainder;
        }
    }

    private void writeStep(BinaryOutputStream bos, List outputItems) throws IOException, ImageWriteException {
        this.writeImageFileHeader(bos);
        for (int i = 0; i < outputItems.size(); ++i) {
            TiffOutputItem outputItem = (TiffOutputItem)outputItems.get(i);
            outputItem.writeItem(bos);
            int length = outputItem.getItemLength();
            int remainder = TiffImageWriterLossy.imageDataPaddingLength(length);
            for (int j = 0; j < remainder; ++j) {
                bos.write(0);
            }
        }
    }
}

