/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseRowObjectMatrix2D
extends AbstractSparseObjectMatrix2D
implements Wrapper<Map<Long, Matrix>> {
    private static final long serialVersionUID = -5291604525500706427L;
    private long[] size = new long[]{1L, 1L};
    private Map<Long, Matrix> rows = new HashMap<Long, Matrix>();

    public DefaultSparseRowObjectMatrix2D(long ... size) {
        this.setSize(size);
    }

    public DefaultSparseRowObjectMatrix2D(Matrix m) {
        this.setSize(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    @Override
    public Object getObject(long row, long column) throws MatrixException {
        Matrix m = this.rows.get(row);
        return m == null ? null : m.getAsObject(0L, column);
    }

    @Override
    public Object getObject(int row, int column) throws MatrixException {
        Matrix m = this.rows.get(row);
        return m == null ? null : m.getAsObject(0L, column);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        ArrayList<long[]> coordinates = new ArrayList<long[]>();
        for (Long r : this.rows.keySet()) {
            Matrix m = this.rows.get(r);
            for (long[] c : m.availableCoordinates()) {
                long[] lArray = new long[2];
                lArray[0] = r;
                coordinates.add(Coordinates.plus(c, lArray));
            }
        }
        return coordinates;
    }

    @Override
    public boolean contains(long ... coordinates) {
        if (Coordinates.isSmallerThan(coordinates, this.size)) {
            return this.getObject(coordinates) != null;
        }
        return false;
    }

    @Override
    public double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) throws MatrixException {
        this.setObject((Object)value, coordinates);
    }

    @Override
    public void setObject(Object o, long row, long column) throws MatrixException {
        Matrix m = this.rows.get(row);
        if (m == null) {
            m = new DefaultSparseObjectMatrix(1L, this.getColumnCount());
            this.rows.put(row, m);
        }
        m.setAsObject(o, 0L, column);
    }

    @Override
    public void setObject(Object o, int row, int column) throws MatrixException {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setSize(long ... size) {
        if (this.size[1] != size[1]) {
            for (Matrix m : this.rows.values()) {
                m.setSize(1L, size[1]);
            }
        }
        this.size = size;
    }

    public Matrix getRow(long row) {
        return this.rows.get(row);
    }

    @Override
    public Matrix max(Calculation.Ret returnType, int dimension) throws MatrixException {
        if (returnType == Calculation.Ret.NEW) {
            if (dimension == 0) {
                Matrix ret = Matrix.factory.zeros(1L, this.getColumnCount());
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{0L, c[1]};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, 0L, c[1]);
                }
                return ret;
            }
            if (dimension == 1) {
                Matrix ret = Matrix.factory.zeros(this.getRowCount(), 1L);
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{c[0], 0L};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, c[0], 0L);
                }
                return ret;
            }
        }
        throw new MatrixException("not supported");
    }

    @Override
    public Matrix selectRows(Calculation.Ret returnType, long ... rows) throws MatrixException {
        if (returnType == Calculation.Ret.LINK && rows.length == 1) {
            return this.getRow(rows[0]);
        }
        return super.selectRows(returnType, rows);
    }

    @Override
    public Map<Long, Matrix> getWrappedObject() {
        return this.rows;
    }

    @Override
    public void setWrappedObject(Map<Long, Matrix> object) {
        this.rows = object;
    }
}

