/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDCSCIEBased;

public class PDCSLab
extends PDCSCIEBased {
    private static final float[] BlackPointDefault = new float[]{0.0f, 0.0f, 0.0f};
    public static final COSName DK_BlackPoint = COSName.constant("BlackPoint");
    public static final COSName DK_Range = COSName.constant("Range");
    public static final COSName DK_WhitePoint = COSName.constant("WhitePoint");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static final float[] RangeDefault = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
    private float[] blackPoint;
    private float[] range;
    private float[] whitePoint;

    protected PDCSLab(COSObject object) {
        super(object);
        int index;
        COSDictionary dict = ((COSArray)object).get(1).asDictionary();
        COSArray blackPointArray = dict.get(DK_BlackPoint).asArray();
        if (blackPointArray == null) {
            this.blackPoint = BlackPointDefault;
        } else {
            this.blackPoint = new float[3];
            index = 0;
            while (index < this.blackPoint.length) {
                this.blackPoint[index] = ((COSNumber)blackPointArray.get(index)).floatValue();
                ++index;
            }
        }
        COSArray rangeArray = dict.get(DK_Range).asArray();
        if (rangeArray == null) {
            this.range = RangeDefault;
        } else {
            this.range = new float[4];
            index = 0;
            while (index < 4) {
                this.range[index] = ((COSNumber)rangeArray.get(index)).floatValue();
                ++index;
            }
        }
        COSArray whitePointArray = dict.get(DK_WhitePoint).asArray();
        this.whitePoint = new float[3];
        index = 0;
        while (index < this.whitePoint.length) {
            this.whitePoint[index] = ((COSNumber)whitePointArray.get(index)).floatValue();
            ++index;
        }
    }

    public float[] getWhitePoint() {
        return this.whitePoint;
    }

    public static class MetaClass
    extends PDCSCIEBased.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

