/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import java.util.ArrayList;
import java.util.List;

public abstract class PDOutlineNode
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_First = COSName.constant("First");
    public static final COSName DK_Last = COSName.constant("Last");
    public static final COSName DK_Count = COSName.constant("Count");

    protected PDOutlineNode(COSObject object) {
        super(object);
    }

    public void addItem(PDOutlineItem newItem) {
        PDOutlineItem last;
        this.changeCount(1);
        PDOutlineItem first = this.getFirst();
        if (first == null) {
            this.setFirst(newItem);
        }
        if ((last = this.getLast()) != null) {
            last.setNext(newItem);
            newItem.setPrev(last);
        }
        this.setLast(newItem);
        newItem.setParent(this);
    }

    protected void changeCount(int value) {
        int newCount = this.getCount();
        newCount = newCount < 0 ? (newCount -= value) : (newCount += value);
        this.setCount(newCount);
        if (this.getParent() != null) {
            this.getParent().changeCount(value);
        }
    }

    public boolean collapse() {
        if (this.getCount() <= 0) {
            return false;
        }
        this.setCount(-this.getCount());
        if (this.getParent() != null) {
            this.getParent().changeCount(this.getCount());
        }
        return true;
    }

    public boolean expand() {
        if (this.getCount() >= 0) {
            return false;
        }
        this.setCount(-this.getCount());
        if (this.getParent() != null) {
            this.getParent().changeCount(this.getCount());
        }
        return true;
    }

    public List getChildren() {
        ArrayList<PDOutlineItem> result = new ArrayList<PDOutlineItem>();
        PDOutlineItem current = this.getFirst();
        while (current != null) {
            result.add(current);
            current = current.getNext();
        }
        return result;
    }

    public int getCount() {
        return this.getFieldInt(DK_Count, 0);
    }

    public PDOutlineItem getFirst() {
        return (PDOutlineItem)PDOutlineItem.META.createFromCos(this.cosGetField(DK_First));
    }

    public PDOutlineItem getLast() {
        return (PDOutlineItem)PDOutlineItem.META.createFromCos(this.cosGetField(DK_Last));
    }

    protected PDOutlineNode getParent() {
        return null;
    }

    public boolean isOutline() {
        return false;
    }

    public boolean removeItem(PDOutlineItem pItem) {
        if (pItem.getParent() != this) {
            return false;
        }
        this.changeCount(-1);
        if (pItem.getPrev() != null) {
            pItem.getPrev().setNext(pItem.getNext());
        }
        if (pItem.getNext() != null) {
            pItem.getNext().setPrev(pItem.getPrev());
        }
        if (this.getFirst() == pItem) {
            this.setFirst(pItem.getNext());
        }
        if (this.getLast() == pItem) {
            this.setLast(pItem.getPrev());
        }
        pItem.setParent(null);
        return true;
    }

    protected void setCount(int newCount) {
        this.setFieldInt(DK_Count, newCount);
    }

    protected void setFirst(PDOutlineItem first) {
        this.setFieldObject(DK_First, first);
    }

    protected void setLast(PDOutlineItem last) {
        this.setFieldObject(DK_Last, last);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            if (object instanceof COSDictionary) {
                COSDictionary dict = (COSDictionary)object;
                COSName type = dict.get(PDObject.DK_Type).asName();
                if (PDOutline.CN_Type_Outlines.equals(type)) {
                    return PDOutline.META;
                }
                if (dict.get(PDOutlineItem.DK_Parent).isNull() && dict.get(PDOutlineItem.DK_Title).isNull()) {
                    return PDOutline.META;
                }
                return PDOutlineItem.META;
            }
            return super.doDetermineClass(object);
        }

        public Class getRootClass() {
            return PDOutlineNode.class;
        }
    }
}

