/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Utils;
import adams.core.io.Log;
import adams.gui.core.ConsolePanel;
import java.io.Serializable;

public class PrintObject
implements Serializable {
    private static final long serialVersionUID = 8419141294301631442L;
    protected String m_OwnerClassname;
    protected int m_OwnerHashcode;
    protected OutputType m_OutputType;
    protected String m_Prefix;
    protected String m_Suffix;
    protected boolean m_UseStdOut;
    protected boolean m_Enabled;
    protected transient ConsolePanel m_ConsolePanel;

    public PrintObject(Object owner, OutputType outputType, boolean enabled, String prefix) {
        this.m_OwnerClassname = owner.getClass().getName();
        this.m_OwnerHashcode = owner.hashCode();
        this.m_OutputType = outputType;
        this.m_Prefix = prefix;
        this.m_Enabled = enabled;
        switch (this.m_OutputType) {
            case STDOUT: {
                this.m_UseStdOut = true;
                this.m_Suffix = "-OUT";
                break;
            }
            case STDERR: {
                this.m_UseStdOut = false;
                this.m_Suffix = "-ERR";
                break;
            }
            case DEBUG: {
                this.m_UseStdOut = true;
                this.m_Suffix = "-DEBUG";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
            }
        }
    }

    public String createPrefix() {
        String result = this.m_OwnerClassname + "/" + this.m_OwnerHashcode;
        return result;
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
    }

    public String getPrefix() {
        if (this.m_Prefix == null) {
            this.m_Prefix = this.createPrefix();
        }
        return this.m_Prefix;
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public void printPrefix() {
        this.print(this.getPrefix());
    }

    protected void doPrint(String msg) {
        if (!this.m_Enabled) {
            return;
        }
        if (this.m_UseStdOut) {
            Log.getSingleton().printOut(msg);
        } else {
            Log.getSingleton().printErr(msg);
        }
        if (this.m_ConsolePanel == null) {
            this.m_ConsolePanel = ConsolePanel.getSingleton();
        }
        this.m_ConsolePanel.append(this.m_OutputType, msg);
    }

    public void print(String msg) {
        this.doPrint(msg);
    }

    public void print(boolean x) {
        this.doPrint(Boolean.toString(x));
    }

    public void print(char x) {
        this.doPrint(Character.toString(x));
    }

    public void print(char[] x) {
        this.doPrint(new String(x));
    }

    public void print(double x) {
        this.doPrint(Double.toString(x));
    }

    public void print(float x) {
        this.doPrint(Float.toString(x));
    }

    public void print(int x) {
        this.doPrint(Integer.toString(x));
    }

    public void print(Object x) {
        this.doPrint("" + x);
    }

    public void print(long x) {
        this.doPrint(Long.toString(x));
    }

    protected void doPrintln(String msg) {
        if (!this.m_Enabled) {
            return;
        }
        this.getPrefix();
        StringBuilder msgBuf = new StringBuilder();
        String[] lines = msg.split("\n");
        String actualPrefix = this.m_Prefix.length() > 0 ? "[" + this.m_Prefix + this.m_Suffix + "]" : "";
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                msgBuf.append("\n");
            }
            msgBuf.append(actualPrefix);
            msgBuf.append(lines[i]);
        }
        if (this.m_UseStdOut) {
            Log.getSingleton().printlnOut(msgBuf.toString());
        } else {
            Log.getSingleton().printlnErr(msgBuf.toString());
        }
        msgBuf.append("\n");
        if (this.m_ConsolePanel == null) {
            this.m_ConsolePanel = ConsolePanel.getSingleton();
        }
        this.m_ConsolePanel.append(this.m_OutputType, msgBuf.toString());
        msgBuf = null;
        lines = null;
    }

    public void println(String msg) {
        this.doPrintln(msg);
    }

    public void println() {
        this.doPrintln("");
    }

    public void println(boolean x) {
        this.doPrintln(Boolean.toString(x));
    }

    public void println(char x) {
        this.doPrintln(Character.toString(x));
    }

    public void println(char[] x) {
        this.doPrintln(new String(x));
    }

    public void println(double x) {
        this.doPrintln(Double.toString(x));
    }

    public void println(float x) {
        this.doPrintln(Float.toString(x));
    }

    public void println(int x) {
        this.doPrintln(Integer.toString(x));
    }

    public void println(Object x) {
        this.doPrintln("" + x);
    }

    public void println(long x) {
        this.doPrintln(Long.toString(x));
    }

    public void printStackTrace(Throwable x) {
        this.doPrintln(Utils.throwableToString(x));
    }

    public static enum OutputType {
        STDOUT,
        STDERR,
        DEBUG;

    }
}

