/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.DateFormat;
import java.lang.reflect.Method;

public class SizeOf {
    public static final String CLASS_SIZEOF = "sizeof.agent.SizeOfAgent";
    public static final String METHOD_FULLSIZEOF = "fullSizeOf";
    protected static Boolean m_Available;
    protected static Class m_Class;
    protected static Method m_Method;

    public static synchronized boolean isSizeOfAgentAvailable() {
        if (m_Available == null) {
            try {
                m_Class = Class.forName(CLASS_SIZEOF);
                m_Method = m_Class.getMethod(METHOD_FULLSIZEOF, Object.class);
            }
            catch (Exception e) {
                m_Class = null;
                m_Method = null;
                m_Available = false;
                System.err.println("SizeOf agent not on classpath available!");
            }
            if (m_Class != null) {
                try {
                    Long size = (Long)m_Method.invoke(null, new Integer(1));
                    m_Available = size > 0L;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    m_Available = false;
                    System.err.println("SizeOf agent not available! Use '-javaagent:sizeofag.jar' on commandline.");
                }
            }
        }
        return m_Available;
    }

    public static int sizeOf(Object obj) {
        Long result = -1L;
        if (SizeOf.isSizeOfAgentAvailable()) {
            try {
                result = (Long)m_Method.invoke(null, obj);
            }
            catch (Exception e) {
                result = -1L;
            }
        }
        return result.intValue();
    }

    public static void main(String[] args) {
        System.out.println(SizeOf.sizeOf(args));
        System.out.println(SizeOf.sizeOf(new Integer(1)));
        System.out.println(SizeOf.sizeOf(new Double(1.0)));
        System.out.println(SizeOf.sizeOf(new DateFormat("yyyy-MM-dd")));
    }
}

