/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;
import adams.data.filter.event.GlobalDataContainerFilterChangeEvent;
import adams.data.filter.event.GlobalDataContainerFilterChangeListener;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractGlobalDataContainerFilter<T extends DataContainer> {
    protected AbstractFilter m_DefaultFilter;
    protected AbstractFilter m_Filter;
    protected HashSet<GlobalDataContainerFilterChangeListener> m_ChangeListeners = new HashSet();

    protected AbstractGlobalDataContainerFilter() {
    }

    public synchronized void setFilter(AbstractFilter value) {
        if (this.m_DefaultFilter == null || !this.m_DefaultFilter.equals(value)) {
            this.m_DefaultFilter = value;
            this.setupFilter();
            this.notifyChangeListeners(new GlobalDataContainerFilterChangeEvent(this));
        }
    }

    public final AbstractFilter getFilter() {
        if (this.m_DefaultFilter == null) {
            return new PassThrough();
        }
        return this.m_DefaultFilter;
    }

    protected synchronized void setupFilter() {
        if (this.m_DefaultFilter != null) {
            this.m_Filter = !(this.m_DefaultFilter instanceof PassThrough) ? this.m_DefaultFilter.shallowCopy(true) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T filter(T c) {
        if (this.m_Filter != null) {
            AbstractFilter filter;
            AbstractFilter abstractFilter = this.m_Filter;
            synchronized (abstractFilter) {
                filter = this.m_Filter.shallowCopy(true);
            }
            c = filter.filter(c);
            filter.destroy();
        }
        return c;
    }

    public void addChangeListener(GlobalDataContainerFilterChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(GlobalDataContainerFilterChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners(GlobalDataContainerFilterChangeEvent e) {
        Iterator<GlobalDataContainerFilterChangeListener> iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().filterStateChanged(e);
        }
    }
}

