/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ConsoleObject;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.flow.core.AbstractActor;
import java.util.HashSet;

public class PauseStateManager
extends ConsoleObject {
    private static final long serialVersionUID = -7910626028332275790L;
    protected HashSet<FlowPauseStateListener> m_Listeners = new HashSet();
    protected boolean m_Paused = false;

    public synchronized void addListener(FlowPauseStateListener l) {
        this.m_Listeners.add(l);
    }

    public synchronized void removeListener(FlowPauseStateListener l) {
        this.m_Listeners.remove(l);
    }

    protected synchronized void notifyListeners(FlowPauseStateEvent e) {
        FlowPauseStateListener[] listeners;
        for (FlowPauseStateListener l : listeners = this.m_Listeners.toArray(new FlowPauseStateListener[this.m_Listeners.size()])) {
            l.flowPauseStateChanged(e);
        }
    }

    public synchronized void pause(AbstractActor source) {
        if (this.m_Paused) {
            return;
        }
        this.m_Paused = true;
        this.notifyListeners(new FlowPauseStateEvent(source, FlowPauseStateEvent.Type.PAUSED));
    }

    public synchronized void resume(AbstractActor source) {
        if (!this.m_Paused) {
            return;
        }
        this.m_Paused = false;
        this.notifyListeners(new FlowPauseStateEvent(source, FlowPauseStateEvent.Type.RESUMED));
    }

    public synchronized boolean isPaused() {
        return this.m_Paused;
    }
}

