/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.flow.sink.sequenceplotter.AbstractSequencePostProcessor;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;

public class SimplePruning
extends AbstractSequencePostProcessor {
    private static final long serialVersionUID = -7354044974316978487L;
    protected int m_Limit;

    @Override
    public String globalInfo() {
        return "Simply prunes the sequences at the head if they exceed a pre-defined size limit.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("limit", "limit", -1, -1, null);
    }

    public void setLimit(int value) {
        if (value >= -1) {
            this.m_Limit = value;
            this.reset();
        } else {
            this.getSystemErr().println("Limit must be >= -1, provided: " + value);
        }
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The size limit for sequences; use -1 for unlimited.";
    }

    @Override
    public boolean postProcess(XYSequenceContainerManager manager, String plotName) {
        boolean result = false;
        XYSequence seq = ((XYSequenceContainer)manager.get(manager.indexOf(plotName))).getData();
        while (seq.size() > this.m_Limit) {
            seq.toList().remove(0);
            result = true;
        }
        return result;
    }
}

