/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.JTableHelper;
import adams.gui.core.MouseUtils;
import adams.gui.event.PopupMenuListener;
import adams.gui.event.RemoveItemsEvent;
import adams.gui.event.RemoveItemsListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTable
extends JTable {
    private static final long serialVersionUID = -2360462659067336490L;
    protected JTableHelper m_TableHelper;
    protected HashSet<RemoveItemsListener> m_RemoveItemsListeners;
    protected HashSet<PopupMenuListener> m_HeaderPopupMenuListeners;
    protected HashSet<PopupMenuListener> m_CellPopupMenuListeners;

    public BaseTable() {
        this.initGUI();
    }

    public BaseTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initGUI();
    }

    public BaseTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initGUI();
    }

    public BaseTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initGUI();
    }

    public BaseTable(TableModel dm) {
        super(dm);
        this.initGUI();
    }

    public BaseTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initGUI();
    }

    public BaseTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initGUI();
    }

    protected JTableHelper getTableHelper() {
        if (this.m_TableHelper == null) {
            this.m_TableHelper = new JTableHelper(this);
        }
        return this.m_TableHelper;
    }

    protected void initGUI() {
        this.m_RemoveItemsListeners = new HashSet();
        this.m_HeaderPopupMenuListeners = new HashSet();
        this.m_CellPopupMenuListeners = new HashSet();
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick(e) && e.isControlDown() && !e.isAltDown() && !e.isShiftDown()) {
                    final int col = BaseTable.this.columnAtPoint(e.getPoint());
                    if (col != -1 && BaseTable.this.isVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BaseTable.this.getTableHelper().setOptimalColumnWidth(col);
                            }
                        });
                    }
                } else if (MouseUtils.isDoubleClick(e) && e.isControlDown() && !e.isAltDown() && e.isShiftDown()) {
                    if (BaseTable.this.isVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BaseTable.this.getTableHelper().setOptimalColumnWidth();
                            }
                        });
                    }
                } else if (MouseUtils.isRightClick(e)) {
                    BaseTable.this.notifyHeaderPopupMenuListener(e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    BaseTable.this.notifyCellPopupMenuListener(e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseTable.this.m_RemoveItemsListeners.size() > 0 && e.getKeyCode() == 127 && e.getModifiers() == 0) {
                    e.consume();
                    BaseTable.this.notifyRemoveItemsListeners(BaseTable.this.getSelectedRows());
                }
            }
        });
    }

    public void setOptimalColumnWidth() {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTable.this.getTableHelper().setOptimalColumnWidth();
                }
            });
        }
    }

    public void setOptimalColumnWidth(final int column) {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTable.this.getTableHelper().setOptimalColumnWidth(column);
                }
            });
        }
    }

    public void scrollRowToVisible(int row) {
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    public void scrollColumnToVisible(int col) {
        this.scrollRectToVisible(this.getCellRect(0, col, true));
    }

    public void addRemoveItemsListener(RemoveItemsListener l) {
        this.m_RemoveItemsListeners.add(l);
    }

    public void removeRemoveItemsListener(RemoveItemsListener l) {
        this.m_RemoveItemsListeners.remove(l);
    }

    protected void notifyRemoveItemsListeners(int[] indices) {
        RemoveItemsEvent event = new RemoveItemsEvent(this, indices);
        for (RemoveItemsListener l : this.m_RemoveItemsListeners) {
            l.removeItems(event);
        }
    }

    public void addHeaderPopupMenuListener(PopupMenuListener l) {
        this.m_HeaderPopupMenuListeners.add(l);
    }

    public void removeHeaderPopupMenuListener(PopupMenuListener l) {
        this.m_HeaderPopupMenuListeners.remove(l);
    }

    protected void notifyHeaderPopupMenuListener(MouseEvent e) {
        for (PopupMenuListener l : this.m_HeaderPopupMenuListeners) {
            l.showPopupMenu(e);
        }
    }

    public void addCellPopupMenuListener(PopupMenuListener l) {
        this.m_CellPopupMenuListeners.add(l);
    }

    public void removeCellPopupMenuListener(PopupMenuListener l) {
        this.m_CellPopupMenuListeners.remove(l);
    }

    protected void notifyCellPopupMenuListener(MouseEvent e) {
        for (PopupMenuListener l : this.m_CellPopupMenuListeners) {
            l.showPopupMenu(e);
        }
    }

    public void copyToClipboard() {
        Action copy = this.getActionMap().get("copy");
        ActionEvent event = new ActionEvent(this, 1001, "");
        copy.actionPerformed(event);
    }
}

