/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class ParameterPanel
extends BasePanel {
    private static final long serialVersionUID = 7164103981772081436L;
    protected Vector<JPanel> m_Rows;
    protected Vector<JLabel> m_Labels;
    protected Vector<Component> m_Parameters;
    protected int m_GapHorizontal;
    protected int m_GapVertical;
    protected Dimension m_PreferredDimensionJSpinner;

    public ParameterPanel() {
        this(0, 0);
    }

    public ParameterPanel(int hgap, int vgap) {
        this.m_GapHorizontal = hgap;
        this.m_GapVertical = vgap;
        this.update();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Rows = new Vector();
        this.m_Labels = new Vector();
        this.m_Parameters = new Vector();
        this.m_PreferredDimensionJSpinner = new Dimension(100, 20);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.update();
    }

    public void clearParameters() {
        this.m_Rows.clear();
        this.m_Labels.clear();
        this.m_Parameters.clear();
        this.update();
    }

    public void setPreferredDimensionJSpinner(Dimension value) {
        this.m_PreferredDimensionJSpinner = (Dimension)value.clone();
        this.update();
    }

    public Dimension getPreferredDimensionJSpinner() {
        return this.m_PreferredDimensionJSpinner;
    }

    public void addParameter(String label, Component comp) {
        this.addParameter(-1, label, comp);
    }

    public void addParameter(AbstractChooserPanel chooser) {
        this.addParameter(-1, chooser);
    }

    public void addParameter(int index, String label, Component comp) {
        JLabel lbl = new JLabel(label.replace("_", ""));
        lbl.setDisplayedMnemonic(GUIHelper.getMnemonic(label));
        lbl.setLabelFor(comp);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(lbl);
        panel.add(comp);
        if (index == -1) {
            this.m_Rows.add(panel);
            this.m_Labels.add(lbl);
            this.m_Parameters.add(comp);
        } else {
            this.m_Rows.add(index, panel);
            this.m_Labels.add(index, lbl);
            this.m_Parameters.add(index, comp);
        }
        this.update();
    }

    public void addParameter(int index, AbstractChooserPanel chooser) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(chooser);
        if (index == -1) {
            this.m_Rows.add(panel);
            this.m_Labels.add(chooser.getPrefixLabel());
            this.m_Parameters.add(chooser);
        } else {
            this.m_Rows.add(index, panel);
            this.m_Labels.add(index, chooser.getPrefixLabel());
            this.m_Parameters.add(index, chooser);
        }
        this.update();
    }

    public void removeParameter(int index) {
        this.m_Rows.remove(index);
        this.m_Labels.remove(index);
        this.m_Parameters.remove(index);
        this.update();
    }

    public Component getParameter(int index) {
        return this.m_Parameters.get(index);
    }

    public int getParameterCount() {
        return this.m_Parameters.size();
    }

    public JLabel getLabel(int index) {
        return this.m_Labels.get(index);
    }

    protected void update() {
        int i;
        this.setLayout(new GridLayout(this.m_Rows.size(), 1, this.m_GapHorizontal, this.m_GapVertical));
        for (i = 0; i < this.m_Rows.size(); ++i) {
            this.add(this.m_Rows.get(i));
        }
        for (i = 0; i < this.m_Rows.size(); ++i) {
            if (!(this.m_Parameters.get(i) instanceof JSpinner)) continue;
            ((JSpinner)this.m_Parameters.get(i)).setPreferredSize((Dimension)this.m_PreferredDimensionJSpinner.clone());
        }
        Dimension preferred = new Dimension(0, 0);
        for (i = 0; i < this.m_Rows.size(); ++i) {
            if (!(this.m_Labels.get(i).getPreferredSize().getWidth() > preferred.getWidth())) continue;
            preferred = this.m_Labels.get(i).getPreferredSize();
        }
        for (i = 0; i < this.m_Rows.size(); ++i) {
            this.m_Labels.get(i).setPreferredSize(preferred);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            this.m_Parameters.get(i).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }
}

