/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.event;

import adams.core.Utils;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import java.util.EventObject;

public class DataChangeEvent
extends EventObject {
    private static final long serialVersionUID = 3847803691713697508L;
    protected Type m_Type;
    protected int[] m_Indices;
    protected Container[] m_Containers;

    public DataChangeEvent(ContainerManager source, Type type) {
        this(source, type, null);
    }

    public DataChangeEvent(ContainerManager source, Type type, int index) {
        this(source, type, new int[]{index}, null);
    }

    public DataChangeEvent(ContainerManager source, Type type, int index, Container cont) {
        this(source, type, new int[]{index}, new Container[]{cont});
    }

    public DataChangeEvent(ContainerManager source, Type type, int[] indices) {
        this(source, type, indices, null);
    }

    public DataChangeEvent(ContainerManager source, Type type, int[] indices, Container[] cont) {
        super(source);
        this.m_Type = type;
        this.m_Containers = cont;
        this.m_Indices = (int[])(indices != null ? (int[])indices.clone() : null);
        if (this.m_Indices != null && this.m_Containers != null && this.m_Indices.length != this.m_Containers.length) {
            throw new IllegalArgumentException("Number of indices and containers don't match: " + this.m_Indices.length + " != " + this.m_Containers.length);
        }
    }

    public ContainerManager getManager() {
        return (ContainerManager)this.getSource();
    }

    public Type getType() {
        return this.m_Type;
    }

    public int[] getIndices() {
        return this.m_Indices;
    }

    public Container[] getContainers() {
        return this.m_Containers;
    }

    @Override
    public String toString() {
        String result = this.getSource().getClass().getName() + "/" + this.getSource().hashCode();
        result = result + ", type=" + (Object)((Object)this.getType());
        if (this.getIndices() != null) {
            result = result + ", indices=" + Utils.arrayToString(this.getIndices());
        }
        if (this.getContainers() != null) {
            result = result + ", # containers=" + this.getContainers().length;
        }
        return result;
    }

    public static enum Type {
        CLEAR,
        ADDITION,
        REMOVAL,
        REPLACEMENT,
        UPDATE,
        BULK_UPDATE,
        VISIBILITY;

    }
}

