/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.core.DebugHelper;
import adams.core.Properties;
import adams.core.Utils;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.UpdateVariable;
import java.util.Enumeration;
import java.util.Vector;

public class ActorTemplateSuggestion {
    private static final boolean DEBUG = DebugHelper.isDebugOn(ActorTemplateSuggestion.class);
    public static final String FILENAME = "ActorTemplateSuggestion.props";
    public static final String KEY_DEFAULT = "Default";
    protected Properties m_Properties;
    protected AbstractActorTemplate[] m_Defaults;
    protected String[] m_Rules;
    protected static ActorTemplateSuggestion m_Singleton;

    private ActorTemplateSuggestion() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Properties = Environment.getInstance().read("actor template suggestion");
        String[] parts = this.m_Properties.getProperty(KEY_DEFAULT, "adams.flow.template.UpdateVariable").split(",");
        Vector<AbstractActorTemplate> templates = new Vector<AbstractActorTemplate>();
        for (int i = 0; i < parts.length; ++i) {
            try {
                templates.add((AbstractActorTemplate)Class.forName(parts[i]).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate default actor template '" + parts[i] + "':");
                e.printStackTrace();
            }
        }
        if (templates.size() == 0) {
            templates.add(new UpdateVariable());
        }
        this.m_Defaults = templates.toArray(new AbstractActorTemplate[templates.size()]);
        if (DEBUG) {
            DebugHelper.debug(this.getClass(), "Defaults: " + Utils.arrayToString(this.m_Defaults, true));
        }
        Vector<String> rules = new Vector<String>();
        Enumeration<?> names = this.m_Properties.propertyNames();
        adams.parser.ActorTemplateSuggestion suggestion = new adams.parser.ActorTemplateSuggestion();
        suggestion.setParent(new Flow());
        suggestion.setPosition(0);
        suggestion.setActors(new AbstractActor[0]);
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals(KEY_DEFAULT)) continue;
            String rule = this.m_Properties.getProperty(name);
            try {
                suggestion.setExpression(rule);
                suggestion.evaluate();
                rules.add(rule);
            }
            catch (Exception e) {
                System.err.println("Invalid actor template suggestion rule: " + rule);
                e.printStackTrace();
            }
        }
        this.m_Rules = rules.toArray(new String[rules.size()]);
        if (DEBUG) {
            DebugHelper.debug(this.getClass(), "Rules: " + Utils.arrayToString(this.m_Rules));
        }
    }

    public AbstractActorTemplate[] getDefaults() {
        return this.m_Defaults;
    }

    public AbstractActorTemplate[] suggest(AbstractActor parent, int position, AbstractActor[] actors) {
        Vector<AbstractActorTemplate> suggestions = new Vector<AbstractActorTemplate>();
        try {
            AbstractActorTemplate[] suggested = adams.parser.ActorTemplateSuggestion.evaluate(this.m_Rules, parent, position, actors);
            for (int i = 0; i < suggested.length; ++i) {
                if (suggested[i] == null) continue;
                suggestions.add(suggested[i]);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to suggest actor templates:");
            e.printStackTrace();
        }
        AbstractActorTemplate[] result = suggestions.toArray(new AbstractActorTemplate[suggestions.size()]);
        if (DEBUG) {
            DebugHelper.debug(this.getClass(), "suggest: parent=" + parent.getClass().getName() + ", " + "position=" + position + ", " + "actors=" + Utils.arrayToString(actors, true) + "\n" + "--> " + Utils.arrayToString(result, true));
        }
        return result;
    }

    public static synchronized ActorTemplateSuggestion getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ActorTemplateSuggestion();
        }
        return m_Singleton;
    }
}

