/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLocator;
import adams.core.EnumWithCustomDisplay;
import adams.core.Utils;
import adams.core.option.EnumOption;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;

public class EnumEditor
extends PropertyEditorSupport
implements MultiSelectionEditor {
    @Override
    public String getJavaInitializationString() {
        String result = "Enum.valueOf(" + this.getValue().getClass().getSimpleName() + ", " + this.getValue().toString() + ")";
        return result;
    }

    @Override
    public String getAsText() {
        return this.getValue().toString();
    }

    @Override
    public void setAsText(String text) {
        if (this.getValue() instanceof EnumWithCustomDisplay) {
            this.setValue(((EnumWithCustomDisplay)this.getValue()).parse(text));
        } else {
            this.setValue(Enum.valueOf(this.getValue().getClass().asSubclass(Enum.class), text));
        }
    }

    @Override
    public String[] getTags() {
        String[] result;
        try {
            Method method = this.getValue().getClass().getMethod("values", new Class[0]);
            Object[] obj = (Object[])method.invoke(null, new Object[0]);
            result = new String[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                result[i] = obj[i].toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new String[]{};
        }
        return result;
    }

    protected static Class determineClass(Object obj) {
        Class<?> result = obj.getClass();
        if (result.isArray()) {
            result = result.getComponentType();
        }
        return result;
    }

    protected Object parse(Class cls, String s) {
        Object result = null;
        if (ClassLocator.hasInterface(EnumWithCustomDisplay.class, cls)) {
            EnumWithCustomDisplay enm = EnumOption.getEnumInstance(cls);
            result = enm.parse(s);
        } else {
            result = Enum.valueOf(cls, s);
        }
        return result;
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the string representations, one per line:");
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        Class cls = EnumEditor.determineClass(this.getValue());
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(cls, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, this.parse(cls, lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(cls, 0);
        }
        return result;
    }
}

