/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.FlowFile;
import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.flow.FlowEditorDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.PropertyPanel;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FlowFileEditor
extends AbstractPropertyEditorSupport
implements PropertyPanel.PopupMenuCustomizer,
CustomStringRepresentationHandler {
    protected BaseFileChooser m_FileChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((FlowFile)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new FlowFile(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return FlowFileEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return FlowFileEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        FlowFile f = (FlowFile)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new FlowFile(\"" + f.getName() + "\")";
    }

    @Override
    protected JComponent createCustomEditor() {
        FlowFile currentFile = (FlowFile)this.getValue();
        this.m_FileChooser = currentFile != null ? new BaseFileChooser() : new BaseFileChooser(new FlowFile(System.getProperty("user.dir")));
        this.m_FileChooser.addChoosableFileFilter(new ExtensionFileFilter("Flow file", "flow"));
        this.m_FileChooser.setApproveButtonText("Select");
        this.m_FileChooser.setApproveButtonMnemonic('S');
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmdString = e.getActionCommand();
                if (cmdString.equals("ApproveSelection")) {
                    FlowFile newVal = new FlowFile(FlowFileEditor.this.m_FileChooser.getSelectedFile());
                    FlowFileEditor.this.setValue(newVal);
                }
                FlowFileEditor.this.closeDialog();
            }
        });
        return this.m_FileChooser;
    }

    @Override
    protected void initForDisplay() {
        FlowFile currentFile = (FlowFile)this.getValue();
        if (currentFile != null) {
            this.m_FileChooser.setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        FlowFile f = (FlowFile)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    public void customizePopup(PropertyPanel owner, JPopupMenu menu) {
        final PropertyPanel fOwner = owner;
        JMenuItem menuitem = new JMenuItem("Open in Flow editor...");
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorDialog dialog = fOwner.getParentDialog() != null ? new FlowEditorDialog(fOwner.getParentDialog()) : new FlowEditorDialog(fOwner.getParentFrame());
                dialog.getFlowEditorPanel().loadUnsafe((FlowFile)FlowFileEditor.this.getValue());
                dialog.setLocationRelativeTo(dialog.getOwner());
                dialog.setVisible(true);
                if (dialog.getFlowEditorPanel().getCurrentFile() != null) {
                    FlowFileEditor.this.setValue(new FlowFile(dialog.getFlowEditorPanel().getCurrentFile()));
                }
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
    }
}

