/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Index;
import adams.core.Range;
import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.SpreadSheet;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;
    protected Index m_SheetIndex;
    protected boolean m_AutoExtendHeader;
    protected Range m_TextColumns;

    public String globalInfo() {
        return "Reads MS Excel files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sheet", "sheetIndex", (Object)"first");
        this.m_OptionManager.add("no-auto-extend-header", "autoExtendHeader", (Object)true);
        this.m_OptionManager.add("text-columns", "textColumns", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_SheetIndex = new Index();
        this.m_TextColumns = new Range();
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xls", "xlsx"};
    }

    public void setSheetIndex(String value) {
        this.m_SheetIndex.setIndex(value);
    }

    public String getSheetIndex() {
        return this.m_SheetIndex.getIndex();
    }

    public String sheetIndexTipText() {
        return "The index of the sheet to load; " + this.m_SheetIndex.getExample();
    }

    public void setAutoExtendHeader(boolean value) {
        this.m_AutoExtendHeader = value;
    }

    public boolean getAutoExtendHeader() {
        return this.m_AutoExtendHeader;
    }

    public String autoExtendHeaderTipText() {
        return "If enabled, the header gets automatically extended if rows have more cells than the header.";
    }

    public void setTextColumns(String value) {
        this.m_TextColumns.setRange(value);
    }

    public String getTextColumns() {
        return this.m_TextColumns.getRange();
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text; " + this.m_TextColumns.getExample();
    }

    protected boolean getUseInputStream() {
        return true;
    }

    protected String numericToString(Cell cell) {
        Double dbl = cell.getNumericCellValue();
        long lng = dbl.longValue();
        if (dbl == (double)lng) {
            return "" + lng;
        }
        return "" + dbl;
    }

    protected SpreadSheet doRead(InputStream in) {
        SpreadSheet result = new SpreadSheet();
        Workbook workbook = null;
        DateFormat dformat = DateUtils.getTimestampFormatter();
        try {
            boolean numeric;
            Cell exCell;
            int i;
            workbook = WorkbookFactory.create((InputStream)in);
            this.m_SheetIndex.setMax(workbook.getNumberOfSheets());
            Sheet sheet = workbook.getSheetAt(this.m_SheetIndex.getIntIndex());
            if (sheet.getLastRowNum() == 0) {
                this.getSystemErr().println("No rows in sheet #" + this.m_SheetIndex.getIndex());
                return result;
            }
            result.setName(sheet.getSheetName());
            Row exRow = sheet.getRow(0);
            SpreadSheet.Row spRow = result.getHeaderRow();
            this.m_TextColumns.setMax((int)exRow.getLastCellNum());
            block10: for (i = 0; i < exRow.getLastCellNum(); ++i) {
                exCell = exRow.getCell(i);
                if (exCell == null) {
                    spRow.addCell("" + (i + 1)).setContent("?");
                    continue;
                }
                numeric = !this.m_TextColumns.isInRange(i);
                switch (exCell.getCellType()) {
                    case 3: 
                    case 5: {
                        spRow.addCell("" + (i + 1)).setContent("column-" + (i + 1));
                        continue block10;
                    }
                    case 0: {
                        if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                            spRow.addCell("" + (i + 1)).setContent(dformat.format(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                            continue block10;
                        }
                        if (numeric) {
                            spRow.addCell("" + (i + 1)).setContent(Double.valueOf(exCell.getNumericCellValue()));
                            continue block10;
                        }
                        spRow.addCell("" + (i + 1)).setContent(this.numericToString(exCell), false);
                        continue block10;
                    }
                    default: {
                        spRow.addCell("" + (i + 1)).setContent(exCell.getStringCellValue(), false);
                    }
                }
            }
            for (i = 1; i < sheet.getLastRowNum(); ++i) {
                spRow = result.addRow("" + result.getRowCount());
                exRow = sheet.getRow(i);
                if (exRow == null) continue;
                block12: for (int n = 0; n < exRow.getLastCellNum(); ++n) {
                    if (n >= result.getHeaderRow().getCellCount() && this.m_AutoExtendHeader) {
                        result.getHeaderRow().addCell("" + n).setContent("");
                    }
                    this.m_TextColumns.setMax(result.getHeaderRow().getCellCount());
                    exCell = exRow.getCell(n);
                    if (exCell == null) {
                        spRow.addCell("" + (n + 1)).setContent("?");
                        continue;
                    }
                    int cellType = exCell.getCellType();
                    if (cellType == 2) {
                        cellType = exCell.getCachedFormulaResultType();
                    }
                    numeric = !this.m_TextColumns.isInRange(n);
                    switch (cellType) {
                        case 3: 
                        case 5: {
                            if (this.m_MissingValue.length() == 0) {
                                spRow.addCell("" + (n + 1)).setContent("?");
                                continue block12;
                            }
                            spRow.addCell("" + (n + 1)).setContent("");
                            continue block12;
                        }
                        case 0: {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)exCell)) {
                                spRow.addCell("" + (n + 1)).setContent(dformat.format(HSSFDateUtil.getJavaDate((double)exCell.getNumericCellValue())));
                                continue block12;
                            }
                            if (numeric) {
                                spRow.addCell("" + (n + 1)).setContent(Double.valueOf(exCell.getNumericCellValue()));
                                continue block12;
                            }
                            spRow.addCell("" + (n + 1)).setContent(this.numericToString(exCell), false);
                            continue block12;
                        }
                        default: {
                            if (exCell.getStringCellValue().equals(this.m_MissingValue)) {
                                spRow.addCell("" + (n + 1)).setContent("?");
                                continue block12;
                            }
                            spRow.addCell("" + (n + 1)).setContent(exCell.getStringCellValue(), false);
                        }
                    }
                }
            }
        }
        catch (Exception ioe) {
            this.getSystemErr().println("Failed to read header:");
            this.getSystemErr().printStackTrace((Throwable)ioe);
            result = null;
        }
        return result;
    }
}

