/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.sequence.IterativeSequenceLearner;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.BaumWelchLearner;
import weka.classifiers.sequence.core.ForwardAlgorithm;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.ImpossibleStateProbabilityException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.NullModel;
import weka.classifiers.sequence.core.NumericStabilityException;
import weka.classifiers.sequence.core.ProbabilityPerStateCalculator;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.SequenceGenerator;
import weka.classifiers.sequence.core.ViterbiAlgorithm;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class IterativeProfileHMMClassifier
extends IterativeSequenceLearner {
    private static final long serialVersionUID = 3134763907535654750L;
    private List<ProfileHMM> allHMMs = new Vector<ProfileHMM>();
    private double[] trainingClassDistribution;
    private List<Double> viterbiScore;
    private List<Double> fwdScore;
    private List<List<Double>> allScore;
    private int iteration;
    private List<Double> logLikelihoodOfPHMM;
    private List<Double> initiallogLikelihoodOfPHMM;
    private List<String[]> allTrainingSequences;
    private List<Double> oldLogLikelihoodOfPHMM;
    private List<Integer> numIterationPerClass;
    protected int positiveClassIndex;
    private List<Instances> datasets;
    private int numPositiveInstances;
    private double artificialPercentage;
    private static final int SAMPLE_ALL = -1;
    private static final int SAMPLE_UNIFORM_ONCE = 0;
    private static final int SAMPLE_HIGHEST = 2;
    private static final int SAMPLE_LOWEST = 3;
    private static final int SAMPLE_UNIFORM = 1;
    private static final int SAMPLE_STRATIFIED = 4;
    private static final int SAMPLE_ARTIFICIAL = 5;
    private static final int SAMPLE_UNIFORM_PLUS = 6;
    private static final int SAMPLE_ARTIFICIAL_NEGATIVE = 7;
    public static final Tag[] TAGS_SAMPLE = new Tag[]{new Tag(-1, "ALL", "no sampling"), new Tag(0, "UNI_ONCE", "take a radom sample of neagtive instances before the first itartion and keep this sample"), new Tag(2, "HIGH", "sample highest scoring negative examples in each iteration"), new Tag(3, "LOW", "sample lowest scoring negative examples in each iteration"), new Tag(1, "UNI", "sample negative examples uniformly in each iteration"), new Tag(6, "UNIPLUS", "sample twice as many negative examples (as there are positive examples) uniformly in each iteration, score the negatives with the positive PHMM and take the high scoring"), new Tag(4, "STRAT", "sample sorted negative examples based on their scores uniformly in each iteration"), new Tag(5, "ART", "create artificial negative examples in first iteration and keep them"), new Tag(7, "ARTNEG", "create artificial negative examples from negative HMM")};
    private boolean loadPositiveModel;
    private IterativeProfileHMMClassifier loadPositiveModelForm;

    public IterativeProfileHMMClassifier() {
        this.logLikelihoodThreshold = 1.0E-4;
        this.useNullModel = false;
        this.transitionsEmissionsNotInLog = false;
        this.learnInsertEmissions = false;
        this.setBaumWelchOption(2);
        this.viterbiProb = false;
        this.fwdProb = false;
        this.allProb = false;
        this.allProbOnly = false;
        this.noBasic = false;
        this.noPathLogScores = false;
        this.logLikelihoodOfPHMM = new Vector<Double>();
        this.initiallogLikelihoodOfPHMM = new Vector<Double>();
        this.allTrainingSequences = new Vector<String[]>();
        this.converged = new Vector();
        this.oldLogLikelihoodOfPHMM = new Vector<Double>();
        this.numIterationPerClass = new Vector<Integer>();
        this.positiveClassIndex = -1;
        this.sampleMethod = -1;
        this.loadPositiveModel = false;
        this.loadPositiveModelForm = null;
        this.artificialPercentage = -1.0;
    }

    @Override
    public Instances propositionalise(Instances oldInstances) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        Instances transformed = this.createPropositionalisedInstancesFormat(oldInstances);
        for (int j = 0; j < oldInstances.numInstances(); ++j) {
            this.viterbiScore = new Vector<Double>();
            this.fwdScore = new Vector<Double>();
            this.allScore = new Vector<List<Double>>();
            Instance oldInstance = oldInstances.instance(j);
            String[] alignment = this.doAlignmentForPropositionalisation(oldInstance);
            transformed = this.doPropositionalisation(alignment, transformed, oldInstance.classValue());
        }
        return transformed;
    }

    @Override
    public Instance propositionaliseTestInstance(Instance oldInstance) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        Instances oldInstances = oldInstance.dataset();
        Instances transformed = this.createPropositionalisedInstancesFormat(oldInstances);
        this.viterbiScore = new Vector<Double>();
        this.fwdScore = new Vector<Double>();
        this.allScore = new Vector<List<Double>>();
        String[] alignment = this.doAlignmentForPropositionalisation(oldInstance);
        transformed = this.doPropositionalisation(alignment, transformed, oldInstance.classValue());
        return transformed.firstInstance();
    }

    private String[] doAlignmentForPropositionalisation(Instance oldInstance) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException {
        String[] alignment = new String[this.allHMMs.size()];
        String test = "";
        test = test + oldInstance.stringValue(oldInstance.attribute(this.sequenceIndex));
        if (this.getRestrictSequenceLength() != -1 && test.length() > this.getRestrictSequenceLength()) {
            test = test.substring(0, this.getRestrictSequenceLength());
        }
        for (int i = 0; i < this.allHMMs.size(); ++i) {
            ProfileHMM hmm = this.allHMMs.get(i);
            if (hmm != null) {
                if (this.isViterbiProb() || !this.isNoBasic()) {
                    ViterbiAlgorithm vitAlg = new ViterbiAlgorithm(this.allHMMs.get(i), test);
                    alignment[i] = vitAlg.calculateViterbiPath();
                    if (this.noBasic) {
                        alignment[i] = "";
                    }
                    this.viterbiScore.add(i, vitAlg.getScore());
                    vitAlg = null;
                } else {
                    alignment[i] = "";
                }
                if (this.isFwdProb()) {
                    ForwardAlgorithm fwd = new ForwardAlgorithm(this.allHMMs.get(i), test);
                    fwd.calculateForward();
                    this.fwdScore.add(i, fwd.getScore());
                    fwd = null;
                }
                if (!this.isAllProb()) continue;
                ProbabilityPerStateCalculator calc = new ProbabilityPerStateCalculator(this.allHMMs.get(i), test);
                this.allScore.add(i, calc.getScores());
                calc = null;
                continue;
            }
            alignment[i] = "";
            this.viterbiScore.add(i, null);
            this.fwdScore.add(i, null);
            this.allScore.add(i, null);
        }
        if (this.noPathLogScores) {
            int i;
            int viterbiSize = this.viterbiScore.size();
            int fwdSize = this.fwdScore.size();
            if (viterbiSize > 0) {
                double[] path = new double[viterbiSize];
                for (i = 0; i < viterbiSize; ++i) {
                    path[i] = this.viterbiScore.get(i);
                }
                path = Utils.logs2probs((double[])path);
                Utils.normalize((double[])path);
                for (i = 0; i < viterbiSize; ++i) {
                    this.viterbiScore.set(i, path[i]);
                }
                path = null;
            }
            if (fwdSize > 0) {
                double[] path = new double[fwdSize];
                for (i = 0; i < fwdSize; ++i) {
                    path[i] = this.fwdScore.get(i);
                }
                path = Utils.logs2probs((double[])path);
                Utils.normalize((double[])path);
                for (i = 0; i < fwdSize; ++i) {
                    this.fwdScore.set(i, path[i]);
                }
                path = null;
            }
        }
        return alignment;
    }

    @Override
    protected Instances doPropositionalisation(String[] allAlignment, Instances transformed, double classValue) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        DenseInstance newInst = new DenseInstance(transformed.numAttributes());
        newInst.setDataset(transformed);
        newInst.setClassValue(classValue);
        int attributeCounter = 0;
        for (int k = 0; k < allAlignment.length; ++k) {
            String alignment = allAlignment[k];
            for (int i = 0; i < alignment.length(); ++i) {
                if (alignment.charAt(i) == '-') {
                    newInst.setValue(attributeCounter, "-");
                    newInst.setValue(++attributeCounter, 0.0);
                    ++attributeCounter;
                    continue;
                }
                if (Character.isUpperCase(alignment.charAt(i))) {
                    newInst.setValue(attributeCounter, alignment.charAt(i) + "");
                    ++attributeCounter;
                }
                if (i < alignment.length() - 1 && Character.isLowerCase(alignment.charAt(i + 1))) {
                    ++i;
                    int count = 0;
                    while (i < alignment.length() && Character.isLowerCase(alignment.charAt(i))) {
                        ++i;
                        ++count;
                    }
                    --i;
                    newInst.setValue(attributeCounter, (double)count);
                    ++attributeCounter;
                    continue;
                }
                if (i >= alignment.length() - 1) continue;
                newInst.setValue(attributeCounter, 0.0);
                ++attributeCounter;
            }
            if (this.isViterbiProb()) {
                newInst.setValue(attributeCounter, this.viterbiScore.get(k).doubleValue());
                ++attributeCounter;
            }
            if (this.isFwdProb()) {
                newInst.setValue(attributeCounter, this.fwdScore.get(k).doubleValue());
                ++attributeCounter;
            }
            if (!this.isAllProb()) continue;
            List<Double> scores = this.allScore.get(k);
            double[] probs = new double[scores.size()];
            if (this.isAllProbOnly()) {
                for (int n = 0; n < scores.size(); ++n) {
                    probs[n] = scores.get(n);
                }
                probs = Utils.logs2probs((double[])probs);
                Utils.normalize((double[])probs);
            }
            for (int j = 0; j < scores.size(); ++j) {
                if (!this.isAllProbOnly()) {
                    newInst.setValue(attributeCounter, scores.get(j).doubleValue());
                } else {
                    newInst.setValue(attributeCounter, probs[j]);
                }
                ++attributeCounter;
            }
        }
        transformed.add((Instance)newInst);
        newInst = null;
        return transformed;
    }

    public Instances createPropositionalisedInstancesFormat(Instances oldInstances) {
        Attribute tempAttribute;
        ProfileHMM hmm;
        Alphabet usedAlphabet = null;
        int numNonClassAttributes = 0;
        for (int i = 0; i < this.allHMMs.size(); ++i) {
            hmm = this.allHMMs.get(i);
            if (hmm == null) continue;
            if (usedAlphabet == null) {
                usedAlphabet = hmm.getAlphabet();
            }
            if (!this.noBasic) {
                numNonClassAttributes += hmm.getNumberMatchStates() * 2 - 1;
            }
            if (this.isViterbiProb()) {
                ++numNonClassAttributes;
            }
            if (this.isFwdProb()) {
                ++numNonClassAttributes;
            }
            if (!this.isAllProb()) continue;
            numNonClassAttributes += hmm.getNumberMatchStates() * 3 - 5;
        }
        FastVector attInfo = new FastVector(numNonClassAttributes + 1);
        FastVector my_nominal_values = new FastVector();
        if (!this.noBasic) {
            for (int i = 0; i < usedAlphabet.alphabetSize(); ++i) {
                my_nominal_values.addElement((Object)usedAlphabet.getSymbolAtIndex(i));
            }
            my_nominal_values.addElement((Object)"-");
        }
        FastVector my_nominal_class_values = new FastVector();
        for (int i = 0; i < oldInstances.numClasses(); ++i) {
            my_nominal_class_values.addElement((Object)oldInstances.classAttribute().value(i));
        }
        int counter = 0;
        int index = 0;
        String tempAttributeName = "";
        for (int i = 0; i < this.allHMMs.size(); ++i) {
            hmm = this.allHMMs.get(i);
            if (!this.noBasic) {
                int numberOfAttributes = 0;
                if (hmm != null) {
                    numberOfAttributes = hmm.getNumberMatchStates() * 2 - 1;
                }
                for (int j = 0; j < numberOfAttributes; ++j) {
                    if (j % 2 == 0) {
                        tempAttributeName = j == 0 || j == numberOfAttributes - 1 ? "Match" + counter + "_HMM" + (index + 1) : "Match_Delete" + counter + "_HMM" + (index + 1);
                        tempAttribute = new Attribute(tempAttributeName, (List)my_nominal_values);
                        attInfo.addElement((Object)tempAttribute);
                        continue;
                    }
                    tempAttributeName = "Insert" + counter + "_HMM" + (index + 1);
                    tempAttribute = new Attribute(tempAttributeName);
                    attInfo.addElement((Object)tempAttribute);
                    ++counter;
                }
            }
            if (this.isViterbiProb()) {
                tempAttribute = new Attribute("ViterbiScore_HMM" + (index + 1));
                attInfo.addElement((Object)tempAttribute);
            }
            if (this.isFwdProb()) {
                tempAttribute = new Attribute("ForwardScore_HMM" + (index + 1));
                attInfo.addElement((Object)tempAttribute);
            }
            if (this.isAllProb()) {
                int j;
                for (j = 1; j < hmm.getNumberMatchStates() - 1; ++j) {
                    tempAttribute = new Attribute("Score4Match" + j + "_HMM" + (index + 1));
                    attInfo.addElement((Object)tempAttribute);
                }
                for (j = 0; j < hmm.getNumberMatchStates() - 1; ++j) {
                    tempAttribute = new Attribute("Score4Insert" + j + "_HMM" + (index + 1));
                    attInfo.addElement((Object)tempAttribute);
                }
                for (j = 0; j < hmm.getNumberMatchStates() - 2; ++j) {
                    tempAttribute = new Attribute("Score4Delete" + j + "_HMM" + (index + 1));
                    attInfo.addElement((Object)tempAttribute);
                }
            }
            ++index;
            counter = 0;
        }
        tempAttribute = new Attribute("class", (List)my_nominal_class_values);
        attInfo.addElement((Object)tempAttribute);
        Instances transformed = new Instances(oldInstances.relationName() + "_propositiopnalized", (ArrayList)attInfo, 1);
        transformed.setClassIndex(numNonClassAttributes);
        return transformed;
    }

    private int determineColumns(String[] sequences) {
        int average = 0;
        for (int i = 0; i < sequences.length; ++i) {
            average += sequences[i].length();
        }
        return Math.round(average / sequences.length);
    }

    public void buildClassifier(Instances data) throws Exception {
        this.initClassifier(data);
        int iteration = 1;
        do {
            this.next(iteration);
            ++iteration;
        } while (!this.fullyConverged());
    }

    public double classifyInstance(Instance instance) throws Exception {
        int index;
        double[] dist = this.distributionForInstance(instance);
        double result = dist[index = Utils.maxIndex((double[])dist)] == 0.0 ? Utils.missingValue() : (double)index;
        return result;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int index;
        int i;
        int i2;
        NullModel nullmodel;
        double[] distribution = new double[this.allHMMs.size()];
        double[] logDistribution = new double[this.allHMMs.size()];
        double sum = 0.0;
        double sumLogScore = Double.NEGATIVE_INFINITY;
        double logProbNullModel = 0.0;
        String testSequence = instance.stringValue(instance.attribute(this.sequenceIndex));
        if (this.getRestrictSequenceLength() != -1 && testSequence.length() > this.getRestrictSequenceLength()) {
            testSequence = testSequence.substring(0, this.getRestrictSequenceLength());
        }
        if (this.isUseNullModel()) {
            nullmodel = new NullModel(true, this.allHMMs.get(0).getAlphabet());
            for (i2 = 0; i2 < testSequence.length(); ++i2) {
                logProbNullModel = IterativeProfileHMMClassifier.logsum(logProbNullModel, nullmodel.getNullModelEmissionProbability(testSequence.charAt(i2) + ""));
            }
        }
        if (!this.isUseNullModel()) {
            nullmodel = new NullModel(true, this.allHMMs.get(0).getAlphabet());
            for (i2 = 0; i2 < testSequence.length(); ++i2) {
                logProbNullModel = IterativeProfileHMMClassifier.logsum(logProbNullModel, nullmodel.getNullModelEmissionProbability(testSequence.charAt(i2) + ""));
            }
            logProbNullModel = 0.0;
        }
        for (i = 0; i < this.allHMMs.size(); ++i) {
            if (this.allHMMs.get(i) == null) {
                logDistribution[i] = Double.NEGATIVE_INFINITY;
                continue;
            }
            ForwardAlgorithm fwd = new ForwardAlgorithm(this.allHMMs.get(i), testSequence);
            fwd.calculateForward();
            double logProbTestSequence = this.isUseNullModel() ? IterativeProfileHMMClassifier.logsum(fwd.getScore(), logProbNullModel) : fwd.getScore();
            sumLogScore = IterativeProfileHMMClassifier.logplus(sumLogScore, logProbTestSequence);
            if (Double.isNaN(logProbTestSequence)) {
                throw new NumericStabilityException("The HMM score is NaN for test sequence " + testSequence);
            }
            logDistribution[i] = logProbTestSequence;
        }
        if (this.sampleMethod == 7) {
            for (i = 0; i < logDistribution.length; ++i) {
                System.out.print(logDistribution[i] + " ");
            }
            System.out.print(" | ");
        }
        for (i = 0; i < distribution.length; ++i) {
            distribution[i] = logDistribution[i] == Double.NEGATIVE_INFINITY || sumLogScore == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(logDistribution[i] - sumLogScore);
            sum += distribution[i];
        }
        if (this.sampleMethod == 7) {
            for (i = 0; i < distribution.length; ++i) {
                System.out.print(distribution[i] + " ");
            }
            System.out.print(" | ");
        }
        if (sum == 0.0) {
            index = Utils.maxIndex((double[])logDistribution);
            if (logDistribution[index] == Double.NEGATIVE_INFINITY) {
                for (i2 = 0; i2 < distribution.length; ++i2) {
                    distribution[i2] = this.trainingClassDistribution[i2];
                    System.out.println("used training Class Distribution");
                }
                Utils.normalize((double[])distribution);
            } else {
                for (i2 = 0; i2 < distribution.length; ++i2) {
                    distribution[i2] = 0.0;
                }
                distribution[index] = 1.0;
                System.out.println("fwd prob all zero, but not log Score, normalized according to logScore");
            }
        } else {
            Utils.normalize((double[])distribution);
        }
        index = -1;
        for (i2 = 0; i2 < distribution.length; ++i2) {
            if (Double.isNaN(distribution[i2])) {
                throw new NumericStabilityException("The HMM score is NaN after normalisation.");
            }
            if (distribution[i2] != 1.0 || index != -1) continue;
            index = i2;
        }
        if (index != -1) {
            for (i2 = 0; i2 < distribution.length; ++i2) {
                if (i2 == index) continue;
                distribution[i2] = 0.0;
            }
        }
        if (this.sampleMethod == 7) {
            for (i2 = 0; i2 < distribution.length; ++i2) {
                System.out.print(distribution[i2] + " ");
            }
            System.out.print("\n");
        }
        return distribution;
    }

    private int determineColumns(Instances inst) {
        int average = 0;
        for (int i = 0; i < inst.numInstances(); ++i) {
            average += inst.instance(i).stringValue(inst.instance(i).attribute(this.sequenceIndex)).length();
        }
        return Math.round(average / inst.numInstances());
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tchooses a method for sampling (default: no sampling)", "Z", 1, "-Z " + Tag.toOptionList((Tag[])TAGS_SAMPLE)));
        result.addElement(new Option("\twhen artifical sampling is used, percentage of overlapping examples according to forward score", "P", 1, "-P "));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getSampleMethod() != -1) {
            result.add("-Z");
            result.add("" + this.getSampleType());
        }
        if (this.getArtificialPercentage() != -1.0) {
            result.add("-P");
            result.add("" + this.getArtificialPercentage());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.positiveClassIndex = 0;
        String numberString = Utils.getOption((char)'P', (String[])options);
        this.artificialPercentage = numberString.length() != 0 ? (double)Integer.parseInt(numberString) : -1.0;
        numberString = Utils.getOption((char)'Z', (String[])options);
        if (numberString.length() != 0) {
            this.setSampleType(new SelectedTag(numberString, TAGS_SAMPLE));
        } else {
            this.setSampleType(new SelectedTag(-1, TAGS_SAMPLE));
        }
    }

    public String toString() {
        String result = " positive class index:\t" + this.positiveClassIndex + "\n sample method:\t" + this.getSampleType();
        if (this.sampleMethod == 5) {
            result = result + " precentage of positive examples with overlapping score: " + this.getArtificialPercentage();
        }
        result = result + "\n";
        if (this.allHMMs != null) {
            for (int i = 0; i < this.allHMMs.size(); ++i) {
                ProfileHMM hmm = this.allHMMs.get(i);
                if (hmm == null) continue;
                result = result + "\nProfileHMM for class " + i + ":\n" + "  match states:    \t" + hmm.getNumberMatchStates() + "\n  iterations in BW:\t" + this.numIterationPerClass.get(i) + "\n  final score:    \t" + this.logLikelihoodOfPHMM.get(i) + "\n  initial score:\t" + this.initiallogLikelihoodOfPHMM.get(i) + "\n";
            }
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            System.out.println(Evaluation.evaluateModel((Classifier)new IterativeProfileHMMClassifier(), (String[])argv));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRevision() {
        return "1.0";
    }

    @Override
    public void initClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (data.numAttributes() > 2) {
            throw new Exception("Dataset has to consist of exactly one string attribute and a class attribute");
        }
        this.sequenceIndex = data.classIndex() == 1 ? 0 : 1;
        this.iteration = 0;
        this.trainingClassDistribution = new double[data.numClasses()];
        Enumeration enist = data.enumerateInstances();
        this.datasets = new Vector<Instances>(data.numClasses());
        for (int j = 0; j < data.numClasses(); ++j) {
            this.datasets.add(j, new Instances(data, data.numInstances()));
        }
        while (enist.hasMoreElements()) {
            Instance temp = (Instance)enist.nextElement();
            Instances instTemp = this.datasets.get((int)temp.classValue());
            this.datasets.remove((int)temp.classValue());
            instTemp.add(temp);
            this.datasets.add((int)temp.classValue(), instTemp);
        }
        if (this.sampleMethod == -1) {
            this.initPHMMAndSequences(data);
        } else {
            this.initPHMMAndSequencesSampling(data);
        }
    }

    private void initPHMMAndSequencesSampling(Instances data) {
        int numInstances = data.numInstances();
        Instances positiveSet = this.datasets.get(this.positiveClassIndex);
        this.numPositiveInstances = positiveSet.numInstances();
        if (positiveSet.numInstances() == 0) {
            this.trainingClassDistribution[0] = 0.0;
            this.allHMMs.add(0, null);
            this.converged.add(0, true);
            this.logLikelihoodOfPHMM.add(0, null);
            this.initiallogLikelihoodOfPHMM.add(0, null);
            this.oldLogLikelihoodOfPHMM.add(0, null);
            this.numIterationPerClass.add(0, null);
        } else {
            ProfileHMM hmm;
            this.trainingClassDistribution[0] = positiveSet.numInstances() / numInstances;
            this.trainingClassDistribution[1] = (numInstances - positiveSet.numInstances()) / numInstances;
            if (this.getRestrictSequenceLength() != -1) {
                hmm = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else if (this.getRestrictMatchColumns() != -1) {
                hmm = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else {
                int matchColumns = this.determineColumns(positiveSet);
                hmm = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            }
            this.allHMMs.add(0, hmm);
            this.converged.add(0, false);
            this.logLikelihoodOfPHMM.add(0, Double.NEGATIVE_INFINITY);
            this.initiallogLikelihoodOfPHMM.add(0, Double.NEGATIVE_INFINITY);
            this.oldLogLikelihoodOfPHMM.add(0, Double.NEGATIVE_INFINITY);
            this.numIterationPerClass.add(0, -1);
        }
        String[] allTrainingSequencesForClass = new String[positiveSet.numInstances()];
        for (int k = 0; k < positiveSet.numInstances(); ++k) {
            String sequence = positiveSet.instance(k).stringValue(positiveSet.instance(k).attribute(this.sequenceIndex));
            if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                sequence = sequence.substring(0, this.getRestrictSequenceLength());
            }
            allTrainingSequencesForClass[k] = sequence;
        }
        this.allTrainingSequences.add(0, allTrainingSequencesForClass);
        this.converged.add(1, false);
        this.logLikelihoodOfPHMM.add(1, Double.NEGATIVE_INFINITY);
        this.initiallogLikelihoodOfPHMM.add(1, Double.NEGATIVE_INFINITY);
        this.oldLogLikelihoodOfPHMM.add(1, Double.NEGATIVE_INFINITY);
        this.numIterationPerClass.add(1, -1);
        if (this.sampleMethod != 0) {
            this.allHMMs.add(1, null);
            this.allTrainingSequences.add(1, null);
        } else {
            ProfileHMM hmm;
            int negativeClassIndex = 1;
            if (this.positiveClassIndex == 1) {
                negativeClassIndex = 0;
            }
            Instances negativeSet = this.datasets.get(negativeClassIndex);
            allTrainingSequencesForClass = new String[positiveSet.numInstances()];
            Random rand = new Random(this.numPositiveInstances + 1);
            for (int i = 0; i < this.numPositiveInstances; ++i) {
                int index = rand.nextInt(negativeSet.numInstances());
                String sequence = negativeSet.instance(index).stringValue(negativeSet.instance(index).attribute(this.sequenceIndex));
                if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                    sequence = sequence.substring(0, this.getRestrictSequenceLength());
                }
                allTrainingSequencesForClass[i] = sequence;
            }
            this.allTrainingSequences.add(1, allTrainingSequencesForClass);
            if (this.getRestrictSequenceLength() != -1) {
                hmm = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else if (this.getRestrictMatchColumns() != -1) {
                hmm = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else {
                int matchColumns = this.determineColumns(allTrainingSequencesForClass);
                hmm = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            }
            this.allHMMs.add(1, hmm);
        }
    }

    private void initPHMMAndSequences(Instances data) {
        int numInstances = data.numInstances();
        for (int i = 0; i < data.numClasses(); ++i) {
            Instances trainingSetClassi = this.datasets.get(i);
            if (trainingSetClassi.numInstances() == 0) {
                this.trainingClassDistribution[i] = 0.0;
                this.allHMMs.add(i, null);
                this.converged.add(i, true);
                this.logLikelihoodOfPHMM.add(i, null);
                this.initiallogLikelihoodOfPHMM.add(i, null);
                this.oldLogLikelihoodOfPHMM.add(i, null);
                this.numIterationPerClass.add(i, null);
            } else {
                ProfileHMM hmm;
                this.trainingClassDistribution[i] = trainingSetClassi.numInstances() / numInstances;
                if (this.getRestrictSequenceLength() != -1) {
                    hmm = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
                } else if (this.getRestrictMatchColumns() != -1) {
                    hmm = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
                } else {
                    int matchColumns = this.determineColumns(trainingSetClassi);
                    hmm = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
                }
                this.allHMMs.add(i, hmm);
                this.converged.add(i, false);
                this.logLikelihoodOfPHMM.add(i, Double.NEGATIVE_INFINITY);
                this.initiallogLikelihoodOfPHMM.add(i, Double.NEGATIVE_INFINITY);
                this.oldLogLikelihoodOfPHMM.add(i, Double.NEGATIVE_INFINITY);
                this.numIterationPerClass.add(i, -1);
            }
            String[] allTrainingSequencesForClass = new String[trainingSetClassi.numInstances()];
            for (int k = 0; k < trainingSetClassi.numInstances(); ++k) {
                String sequence = trainingSetClassi.instance(k).stringValue(trainingSetClassi.instance(k).attribute(this.sequenceIndex));
                if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                    sequence = sequence.substring(0, this.getRestrictSequenceLength());
                }
                allTrainingSequencesForClass[k] = sequence;
            }
            this.allTrainingSequences.add(i, allTrainingSequencesForClass);
        }
    }

    @Override
    public void next(int iteration) throws Exception {
        Object bwl = null;
        this.iteration = iteration;
        if (!this.loadPositiveModel) {
            this.trainOneClass(iteration, 0);
        } else {
            this.load();
        }
        if (this.sampleMethod != -1 && this.sampleMethod != 0) {
            if (this.sampleMethod == 5) {
                this.sampleArtifical();
            } else if (this.sampleMethod == 7) {
                this.sampleArtificalFromNegatives();
            } else {
                this.sampleNegatives();
            }
        }
        this.trainOneClass(iteration, 1);
    }

    private void sampleArtifical() throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        ProfileHMM positiveHMM = this.allHMMs.get(0);
        String[] sampledTrainingSequencesForNegativeClass = new String[this.numPositiveInstances];
        String[] allTrainingSequencesForPositiveClass = this.allTrainingSequences.get(0);
        TreeMap sortedList = this.sort(positiveHMM, allTrainingSequencesForPositiveClass);
        SequenceGenerator seqGen = new SequenceGenerator(positiveHMM, this.iteration);
        double lowestPositiveScore = 0.0;
        if (this.artificialPercentage <= 0.0 || this.artificialPercentage >= 100.0) {
            SortedNegative currentLow = (SortedNegative)sortedList.firstKey();
            lowestPositiveScore = currentLow.getScore();
        } else {
            int index = (int)Math.round(this.artificialPercentage / 100.0 * (double)this.numPositiveInstances);
            SortedNegative currentLow = null;
            for (int i = 0; i < index; ++i) {
                currentLow = (SortedNegative)sortedList.firstKey();
                sortedList.remove(currentLow);
            }
            lowestPositiveScore = currentLow.getScore();
        }
        sortedList = null;
        for (int i = 0; i < this.numPositiveInstances; ++i) {
            String negativeSeq;
            sampledTrainingSequencesForNegativeClass[i] = negativeSeq = seqGen.generateLowerScoringSequence(lowestPositiveScore);
        }
        this.allTrainingSequences.set(1, sampledTrainingSequencesForNegativeClass);
        if (this.allHMMs.get(1) == null) {
            ProfileHMM hmm;
            if (this.getRestrictSequenceLength() != -1) {
                hmm = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else if (this.getRestrictMatchColumns() != -1) {
                hmm = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else {
                int matchColumns = this.determineColumns(sampledTrainingSequencesForNegativeClass);
                hmm = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            }
            this.allHMMs.set(1, hmm);
        }
    }

    private void sampleArtificalFromNegatives() throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        int i;
        if (this.allHMMs.get(1) == null) {
            ProfileHMM hmm;
            if (this.getRestrictSequenceLength() != -1) {
                hmm = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else if (this.getRestrictMatchColumns() != -1) {
                hmm = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else {
                throw new InvalidStructureException("Doesn't work with this sampling method");
            }
            this.allHMMs.set(1, hmm);
        }
        ProfileHMM negativeHMM = this.allHMMs.get(1);
        ProfileHMM positiveHMM = this.allHMMs.get(0);
        TreeMap testList = this.sort(positiveHMM, this.allTrainingSequences.get(0));
        double bound = 0.0;
        for (int u = 0; u < 2; ++u) {
            bound = ((SortedNegative)testList.firstKey()).getScore();
            testList.remove((SortedNegative)testList.firstKey());
        }
        System.out.println(bound);
        testList = null;
        String[] overSampledTrainingSequencesForNegativeClass = new String[2 * this.numPositiveInstances];
        String[] sampledTrainingSequencesForNegativeClass = new String[this.numPositiveInstances];
        SequenceGenerator seqGen = new SequenceGenerator(negativeHMM, this.iteration);
        for (int i2 = 0; i2 < 2 * this.numPositiveInstances; ++i2) {
            String negativeSeq;
            overSampledTrainingSequencesForNegativeClass[i2] = negativeSeq = seqGen.generateLowerScoringSequence(bound);
        }
        String[] test = overSampledTrainingSequencesForNegativeClass;
        double[] length = new double[test.length];
        for (i = 0; i < test.length; ++i) {
            length[i] = test[i].length();
        }
        Arrays.sort(length);
        for (i = 0; i < length.length; ++i) {
            System.out.print(length[i] + " | ");
        }
        System.out.println("\n");
        if (this.artificialPercentage == 0.0) {
            this.allTrainingSequences.set(1, overSampledTrainingSequencesForNegativeClass);
        } else {
            TreeMap sortedList = this.sort(positiveHMM, overSampledTrainingSequencesForNegativeClass);
            for (int i3 = 0; i3 < this.numPositiveInstances; ++i3) {
                SortedNegative currentHigh = this.artificialPercentage > 0.0 ? (SortedNegative)sortedList.lastKey() : (SortedNegative)sortedList.firstKey();
                int index = currentHigh.getIndex();
                System.out.print(index + "," + currentHigh.getScore() + " | ");
                double logProbNullModel = 0.0;
                NullModel nullmodel = new NullModel(true, this.allHMMs.get(0).getAlphabet());
                for (int u = 0; u < overSampledTrainingSequencesForNegativeClass[index].length(); ++u) {
                    logProbNullModel = IterativeProfileHMMClassifier.logsum(logProbNullModel, nullmodel.getNullModelEmissionProbability(null));
                }
                System.out.println("nullscore for index" + index + ": " + logProbNullModel + ";" + overSampledTrainingSequencesForNegativeClass[index].length());
                sortedList.remove(currentHigh);
                sampledTrainingSequencesForNegativeClass[i3] = overSampledTrainingSequencesForNegativeClass[index];
            }
            System.out.println("");
            this.allTrainingSequences.set(1, sampledTrainingSequencesForNegativeClass);
        }
    }

    private void load() {
        this.allHMMs.set(0, this.loadPositiveModelForm.allHMMs.get(this.positiveClassIndex));
        this.converged.set(0, this.loadPositiveModelForm.converged.get(this.positiveClassIndex));
        this.logLikelihoodOfPHMM.set(0, this.loadPositiveModelForm.logLikelihoodOfPHMM.get(this.positiveClassIndex));
        this.initiallogLikelihoodOfPHMM.set(0, this.loadPositiveModelForm.initiallogLikelihoodOfPHMM.get(this.positiveClassIndex));
        this.oldLogLikelihoodOfPHMM.set(0, this.loadPositiveModelForm.oldLogLikelihoodOfPHMM.get(this.positiveClassIndex));
        this.numIterationPerClass.set(0, this.loadPositiveModelForm.numIterationPerClass.get(this.positiveClassIndex));
        this.loadPositiveModel = false;
    }

    private void trainOneClass(int iteration, int index) throws NumericStabilityException, IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        if (this.allTrainingSequences.get(index).length != 0 && !((Boolean)this.converged.get(index)).booleanValue()) {
            BaumWelchLearner bwl = new BaumWelchLearner(this.allTrainingSequences.get(index), this.logLikelihoodThreshold, this.allHMMs.get(index), this.learnInsertEmissions, this.isMemorySensitive());
            if (this.getBaumWelchOption() == 1) {
                bwl.setAverageLikelihoodOverSequenceNumber(true);
            }
            if (this.getBaumWelchOption() == 2) {
                bwl.setAverageLikelihoodOverResidueNumber(true);
            }
            ProfileHMM learnt = bwl.learnFast();
            double logLikelihood = bwl.getLogLikelihood();
            this.logLikelihoodOfPHMM.set(index, logLikelihood);
            if (iteration == 1) {
                this.initiallogLikelihoodOfPHMM.set(index, bwl.getInitialLogLikelihood());
            }
            this.allHMMs.set(index, learnt);
            this.numIterationPerClass.set(index, iteration);
            if (Math.abs(this.oldLogLikelihoodOfPHMM.get(index) - logLikelihood) <= this.logLikelihoodThreshold) {
                this.converged.set(index, true);
                this.numIterationPerClass.set(index, iteration);
            }
            this.oldLogLikelihoodOfPHMM.set(index, bwl.getLogLikelihood());
        }
    }

    private void sampleNegatives() throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        int i;
        Random rand;
        ProfileHMM positiveHMM = this.allHMMs.get(0);
        int negativeClassIndex = 1;
        if (this.positiveClassIndex == 1) {
            negativeClassIndex = 0;
        }
        Instances negativeSet = new Instances(this.datasets.get(negativeClassIndex));
        String[] allTrainingSequencesForClass = new String[negativeSet.numInstances()];
        for (int k = 0; k < negativeSet.numInstances(); ++k) {
            String sequence = negativeSet.instance(k).stringValue(negativeSet.instance(k).attribute(this.sequenceIndex));
            if (this.getRestrictSequenceLength() != -1 && sequence.length() > this.getRestrictSequenceLength()) {
                sequence = sequence.substring(0, this.getRestrictSequenceLength());
            }
            allTrainingSequencesForClass[k] = sequence;
        }
        String[] sampledTrainingSequencesForClass = new String[this.numPositiveInstances];
        if (this.sampleMethod == 1) {
            rand = new Random(this.iteration + this.numPositiveInstances);
            for (i = 0; i < this.numPositiveInstances; ++i) {
                int index = rand.nextInt(negativeSet.numInstances());
                sampledTrainingSequencesForClass[i] = allTrainingSequencesForClass[index];
            }
            this.allTrainingSequences.set(1, sampledTrainingSequencesForClass);
        } else if (this.sampleMethod == 6) {
            rand = new Random(this.iteration + this.numPositiveInstances);
            int limit = 2 * this.numPositiveInstances;
            String[] overSampledTrainingSequencesForClass = new String[limit];
            if (negativeSet.numInstances() < limit) {
                System.out.println("Sampling method doesn't make sense");
                limit = negativeSet.numInstances();
            }
            for (int i2 = 0; i2 < limit; ++i2) {
                int index = rand.nextInt(negativeSet.numInstances());
                overSampledTrainingSequencesForClass[i2] = allTrainingSequencesForClass[index];
            }
            if (this.artificialPercentage == 0.0) {
                this.allTrainingSequences.set(1, overSampledTrainingSequencesForClass);
            } else {
                TreeMap sortedList = this.sort(positiveHMM, overSampledTrainingSequencesForClass);
                for (int i3 = 0; i3 < this.numPositiveInstances; ++i3) {
                    SortedNegative currentHigh = this.artificialPercentage > 0.0 ? (SortedNegative)sortedList.lastKey() : (SortedNegative)sortedList.firstKey();
                    int index = currentHigh.getIndex();
                    sortedList.remove(currentHigh);
                    sampledTrainingSequencesForClass[i3] = overSampledTrainingSequencesForClass[index];
                }
                this.allTrainingSequences.set(1, sampledTrainingSequencesForClass);
            }
        } else {
            int index;
            SortedNegative currentHigh;
            TreeMap sortedList = this.sort(positiveHMM, allTrainingSequencesForClass);
            if (this.sampleMethod == 2) {
                for (i = 0; i < this.numPositiveInstances; ++i) {
                    currentHigh = (SortedNegative)sortedList.lastKey();
                    index = currentHigh.getIndex();
                    sortedList.remove(currentHigh);
                    sampledTrainingSequencesForClass[i] = allTrainingSequencesForClass[index];
                }
            }
            if (this.sampleMethod == 3) {
                for (i = 0; i < this.numPositiveInstances; ++i) {
                    currentHigh = (SortedNegative)sortedList.firstKey();
                    index = currentHigh.getIndex();
                    sortedList.remove(currentHigh);
                    sampledTrainingSequencesForClass[i] = allTrainingSequencesForClass[index];
                }
            }
            if (this.sampleMethod == 4) {
                int numNegativeInstances = allTrainingSequencesForClass.length;
                int groupSize = numNegativeInstances / this.numPositiveInstances;
                int remainder = numNegativeInstances - groupSize * this.numPositiveInstances;
                Random rand2 = new Random(this.iteration + this.numPositiveInstances);
                for (int j = 0; j < this.numPositiveInstances; ++j) {
                    int adjustedGroupSize = groupSize;
                    if (remainder > 0) {
                        --remainder;
                        ++adjustedGroupSize;
                    }
                    int chosenIndex = rand2.nextInt(adjustedGroupSize);
                    for (int i4 = 0; i4 < adjustedGroupSize; ++i4) {
                        SortedNegative currentHigh2 = (SortedNegative)sortedList.firstKey();
                        if (i4 == chosenIndex) {
                            int index2 = currentHigh2.getIndex();
                            sampledTrainingSequencesForClass[j] = allTrainingSequencesForClass[index2];
                        }
                        sortedList.remove(currentHigh2);
                    }
                }
            }
            this.allTrainingSequences.set(1, sampledTrainingSequencesForClass);
            sortedList = null;
        }
        if (this.allHMMs.get(1) == null) {
            ProfileHMM hmm;
            if (this.getRestrictSequenceLength() != -1) {
                hmm = new ProfileHMM(this.getRestrictSequenceLength(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else if (this.getRestrictMatchColumns() != -1) {
                hmm = new ProfileHMM(this.getRestrictMatchColumns(), this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            } else {
                int matchColumns = this.determineColumns(sampledTrainingSequencesForClass);
                hmm = new ProfileHMM(matchColumns, this.getAlphabet(), this.useNullModel, !this.transitionsEmissionsNotInLog);
            }
            this.allHMMs.set(1, hmm);
        }
    }

    private TreeMap sort(ProfileHMM positiveHMM, String[] allTrainingSequencesForClass) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        TreeMap<SortedNegative, Integer> sortedList = new TreeMap<SortedNegative, Integer>();
        for (int i = 0; i < allTrainingSequencesForClass.length; ++i) {
            ForwardAlgorithm fwd = new ForwardAlgorithm(positiveHMM, allTrainingSequencesForClass[i]);
            fwd.calculateForward();
            double score = fwd.getScore();
            SortedNegative sn = new SortedNegative(i, score);
            sortedList.put(sn, i);
        }
        return sortedList;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    @Override
    public boolean fullyConverged() {
        if (this.converged.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.converged.size(); ++i) {
            if (((Boolean)this.converged.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void resetAllTrainingSequences() {
        this.allTrainingSequences = null;
    }

    public int numProfilHMM() {
        return this.allHMMs.size();
    }

    public ProfileHMM getProfileHMM(int i) {
        return this.allHMMs.get(i);
    }

    public void setProfileHMM(ProfileHMM profileHMM, int i) {
        this.allHMMs.add(i, profileHMM);
    }

    public static long getSerialVersionUID() {
        return 3134763907535654750L;
    }

    public int getPositiveClassIndex() {
        return this.positiveClassIndex;
    }

    public void setPositiveClassIndex(int positiveClassIndex) {
        this.positiveClassIndex = positiveClassIndex;
    }

    @Override
    public int getSampleMethod() {
        return this.sampleMethod;
    }

    @Override
    public void setSampleMethod(int sampleMethod) {
        this.sampleMethod = sampleMethod;
    }

    public SelectedTag getSampleType() {
        return new SelectedTag(this.sampleMethod, TAGS_SAMPLE);
    }

    public void setSampleType(SelectedTag newType) {
        if (newType.getTags() == TAGS_SAMPLE) {
            this.sampleMethod = newType.getSelectedTag().getID();
        }
    }

    public boolean isLoadPositiveModel() {
        return this.loadPositiveModel;
    }

    public void setLoadPositiveModel(boolean loadPositiveModel) {
        this.loadPositiveModel = loadPositiveModel;
    }

    public IterativeProfileHMMClassifier getLoadPositiveModelForm() {
        return this.loadPositiveModelForm;
    }

    public void setLoadPositiveModelForm(IterativeProfileHMMClassifier loadPositiveModelForm) {
        this.loadPositiveModelForm = loadPositiveModelForm;
    }

    public double getArtificialPercentage() {
        return this.artificialPercentage;
    }

    public void setArtificialPercentage(double artificialPercentage) {
        this.artificialPercentage = artificialPercentage;
    }

    private class SortedNegative
    implements Comparable<SortedNegative> {
        double score;
        int index;

        public SortedNegative(int i, double d) {
            this.index = i;
            this.score = d;
        }

        @Override
        public int compareTo(SortedNegative sn) {
            if (this.getScore() == Double.NEGATIVE_INFINITY) {
                if (sn.getScore() == Double.NEGATIVE_INFINITY) {
                    return this.getIndex() - sn.getIndex();
                }
                return -1;
            }
            if (sn.getScore() == Double.NEGATIVE_INFINITY) {
                return 1;
            }
            double diff = this.getScore() - sn.getScore();
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return this.getIndex() - sn.getIndex();
        }

        public boolean equals(Object obj) {
            SortedNegative sn = (SortedNegative)obj;
            return sn.getScore() == this.getScore() && sn.getIndex() == this.getIndex();
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

