/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class LogStatesScores2Probabilities
extends Filter
implements SupervisedFilter {
    private static final long serialVersionUID = -7027709161454713739L;

    public String getRevision() {
        return "1.0";
    }

    protected int determineHMMNumber(Instances instances) {
        Attribute att = instances.attribute(instances.numAttributes() - 2);
        String attName = att.name();
        return Integer.parseInt(attName.substring(attName.length() - 1));
    }

    public String globalInfo() {
        return "A batch filter that converts arff files created in Mode 4 to probablities.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(new Instances(instanceInfo, 0));
        return true;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        Instances inst = this.getInputFormat();
        int hmmNumber = this.determineHMMNumber(inst);
        int[] stateIndices = this.determineStateNumbers(inst, hmmNumber);
        for (int i = 0; i < inst.numInstances(); ++i) {
            Instance instance = inst.instance(i);
            int oldStateIndex = 0;
            for (int actualHMM = 0; actualHMM < hmmNumber; ++actualHMM) {
                int k;
                int index = 0;
                double[] probs = new double[stateIndices[actualHMM] + 1 - oldStateIndex];
                for (k = oldStateIndex; k < stateIndices[actualHMM] + 1; ++k) {
                    probs[index] = instance.value(k);
                    ++index;
                }
                probs = Utils.logs2probs((double[])probs);
                Utils.normalize((double[])probs);
                index = 0;
                for (k = oldStateIndex; k < stateIndices[actualHMM] + 1; ++k) {
                    instance.setValue(k, probs[index]);
                    ++index;
                }
                oldStateIndex = stateIndices[actualHMM] + 1;
            }
            this.push(instance);
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected int[] determineStateNumbers(Instances instances, int hmmNumber) {
        int[] maxIndex = new int[hmmNumber];
        int index = 0;
        Attribute att = instances.attribute(0);
        String attName = att.name();
        char numberOne = attName.charAt(attName.length() - 1);
        for (int i = 1; i < instances.numAttributes() - 1; ++i) {
            att = instances.attribute(i);
            attName = att.name();
            char numberTwo = attName.charAt(attName.length() - 1);
            if (numberOne == numberTwo) continue;
            numberOne = numberTwo;
            maxIndex[index] = i - 1;
            ++index;
        }
        maxIndex[hmmNumber - 1] = instances.numAttributes() - 2;
        return maxIndex;
    }

    public static void main(String[] argv) {
        LogStatesScores2Probabilities.runFilter((Filter)new LogStatesScores2Probabilities(), (String[])argv);
    }
}

