/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.CleanUpHandler;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImage;
import adams.data.report.AbstractField;
import adams.data.report.Field;
import adams.data.report.Report;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public abstract class AbstractImageFlattener<T extends AbstractImage>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = 4566948525813804085L;
    protected Instances m_Header;
    protected Field[] m_Fields;
    protected BaseString[] m_Notes;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "fields", (Object)new Field[0]);
        this.m_OptionManager.add("notes", "notes", (Object)new BaseString[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Header = null;
    }

    public void setFields(Field[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public Field[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields to add to the output.";
    }

    public void setNotes(BaseString[] value) {
        this.m_Notes = value;
        this.reset();
    }

    public BaseString[] getNotes() {
        return this.m_Notes;
    }

    public String notesTipText() {
        return "The notes to add as attributes to the generated data, eg 'PROCESS INFORMATION'.";
    }

    protected void checkImage(T img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    public abstract Instances createHeader(T var1);

    public Instances postProcessHeader(Instances header) {
        Add add;
        int i;
        Instances result = header;
        String name = header.relationName();
        for (i = this.m_Notes.length - 1; i >= 0; --i) {
            header = result;
            try {
                add = new Add();
                add.setAttributeIndex("last");
                add.setAttributeName(this.m_Notes[i].getValue());
                add.setAttributeType(new SelectedTag(2, Add.TAGS_TYPE));
                add.setInputFormat(header);
                result = Filter.useFilter((Instances)header, (Filter)add);
                continue;
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to add note '" + this.m_Notes[i] + "' as attribute:");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        for (i = this.m_Fields.length - 1; i >= 0; --i) {
            header = result;
            try {
                add = new Add();
                add.setAttributeIndex("last");
                add.setAttributeName(this.m_Fields[i].toDisplayString());
                switch (this.m_Fields[i].getDataType()) {
                    case BOOLEAN: {
                        add.setAttributeType(new SelectedTag(1, Add.TAGS_TYPE));
                        add.setNominalLabels("no,yes");
                        break;
                    }
                    case NUMERIC: {
                        add.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
                        break;
                    }
                    default: {
                        add.setAttributeType(new SelectedTag(2, Add.TAGS_TYPE));
                    }
                }
                add.setInputFormat(header);
                result = Filter.useFilter((Instances)header, (Filter)add);
                continue;
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to add field '" + this.m_Fields[i] + "' as attribute:");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        result.setRelationName(name);
        return result;
    }

    protected double[] newArray(int numAttributes) {
        double[] result = new double[numAttributes];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Utils.missingValue();
        }
        return result;
    }

    public abstract Instance[] doFlatten(T var1);

    public Instance postProcessInstance(T img, Instance inst) {
        Attribute att;
        int i;
        if (this.m_Notes.length == 0 && this.m_Fields.length == 0) {
            return inst;
        }
        double[] values = inst.toDoubleArray();
        for (i = 0; i < this.m_Notes.length; ++i) {
            att = this.m_Header.attribute(this.m_Notes[i].getValue());
            String valueStr = img.getNotes().getPrefixSubset(this.m_Notes[i].getValue()).toString();
            if (valueStr == null) continue;
            values[att.index()] = att.addStringValue(valueStr);
        }
        Report report = img.getReport();
        block5: for (i = 0; i < this.m_Fields.length; ++i) {
            att = this.m_Header.attribute(this.m_Fields[i].toDisplayString());
            if (!report.hasValue((AbstractField)this.m_Fields[i])) continue;
            switch (this.m_Fields[i].getDataType()) {
                case NUMERIC: {
                    values[att.index()] = report.getDoubleValue((AbstractField)this.m_Fields[i]);
                    continue block5;
                }
                case BOOLEAN: {
                    if (report.getBooleanValue((AbstractField)this.m_Fields[i]).booleanValue()) {
                        values[att.index()] = 1.0;
                        continue block5;
                    }
                    values[att.index()] = 0.0;
                    continue block5;
                }
                default: {
                    values[att.index()] = att.addStringValue(report.getStringValue((AbstractField)this.m_Fields[i]));
                }
            }
        }
        DenseInstance result = new DenseInstance(inst.weight(), values);
        result.setDataset(this.m_Header);
        return result;
    }

    public Instance[] flatten(T img) {
        this.checkImage(img);
        if (this.m_Header == null) {
            Instances header = this.createHeader(img);
            if (header == null) {
                throw new IllegalStateException("Failed to create header!");
            }
            this.m_Header = this.postProcessHeader(header);
        }
        Instance[] result = this.doFlatten(img);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.postProcessInstance(img, result[i]);
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public T shallowCopy() {
        return this.shallowCopy(false);
    }

    public T shallowCopy(boolean expand) {
        return (T)((AbstractImage)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand));
    }

    public void cleanUp() {
        this.reset();
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }
}

