/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.io.ExportMatrix;
import org.ujmp.core.io.ImportMatrixCSV;
import org.ujmp.core.io.ImportMatrixImapFolders;
import org.ujmp.core.io.ImportMatrixImapMessages;

public abstract class ImportMatrix {
    public static Matrix fromFile(File file, Object ... parameters) throws MatrixException, IOException {
        return ImportMatrix.fromFile(ExportMatrix.guessFormat(file), file, parameters);
    }

    public static Matrix fromFile(FileFormat format, File file, Object ... parameters) throws MatrixException, IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.ImportMatrix" + format.name());
            Method m = c.getMethod("fromFile", File.class, Object[].class);
            Matrix matrix = (Matrix)m.invoke(null, file, parameters);
            return matrix;
        }
        catch (ClassNotFoundException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (NoSuchMethodException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (IllegalAccessException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (InvocationTargetException e) {
            throw new MatrixException("could not import", e);
        }
    }

    public static Matrix fromString(String string, Object ... parameters) {
        return ImportMatrixCSV.fromString(string, parameters);
    }

    public static Matrix fromString(FileFormat format, String string, Object parameters) throws MatrixException {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.ImportMatrix" + format.name());
            Method m = c.getMethod("fromString", String.class, Object[].class);
            Matrix matrix = (Matrix)m.invoke(null, string, parameters);
            return matrix;
        }
        catch (ClassNotFoundException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (NoSuchMethodException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (IllegalAccessException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (InvocationTargetException e) {
            throw new MatrixException("could not import", e);
        }
    }

    public static Matrix fromURL(FileFormat format, URL url, Object ... parameters) throws MatrixException, IOException {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(3000);
        Matrix m = ImportMatrix.fromStream(format, connection.getInputStream(), parameters);
        return m;
    }

    public static Matrix fromURL(FileFormat format, String urlString, Object ... parameters) throws MatrixException, IOException {
        if (FileFormat.ImapMessages.equals((Object)format)) {
            return ImportMatrixImapMessages.fromURL(urlString, parameters);
        }
        if (FileFormat.ImapFolders.equals((Object)format)) {
            return ImportMatrixImapFolders.fromURL(urlString, parameters);
        }
        return ImportMatrix.fromURL(format, new URL(urlString), parameters);
    }

    public static Matrix fromStream(FileFormat format, InputStream stream, Object parameters) throws MatrixException, IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.ImportMatrix" + format.name());
            Method m = c.getMethod("fromStream", InputStream.class, Object[].class);
            Matrix matrix = (Matrix)m.invoke(null, stream, parameters);
            return matrix;
        }
        catch (ClassNotFoundException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (NoSuchMethodException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (IllegalAccessException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (InvocationTargetException e) {
            throw new MatrixException("could not import", e);
        }
    }

    public static Matrix fromReader(FileFormat format, Reader reader, Object parameters) throws MatrixException, IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.ImportMatrix" + format.name());
            Method m = c.getMethod("fromReader", Reader.class, Object[].class);
            Matrix matrix = (Matrix)m.invoke(null, reader, parameters);
            return matrix;
        }
        catch (ClassNotFoundException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (NoSuchMethodException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (IllegalAccessException e) {
            throw new MatrixException("format not supported: " + (Object)((Object)format), e);
        }
        catch (InvocationTargetException e) {
            throw new MatrixException("could not import", e);
        }
    }

    public static Matrix fromClipboard(FileFormat format, Object ... parameters) throws MatrixException {
        String s;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(null);
        try {
            s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception ex) {
            s = ex.toString();
        }
        return ImportMatrix.fromString(format, s, (Object)parameters);
    }
}

