/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.matrix;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.bigdecimalmatrix.BigDecimalMatrix;
import org.ujmp.core.bigdecimalmatrix.calculation.ToBigDecimalMatrix;
import org.ujmp.core.bigintegermatrix.BigIntegerMatrix;
import org.ujmp.core.bigintegermatrix.calculation.ToBigIntegerMatrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.booleanmatrix.calculation.And;
import org.ujmp.core.booleanmatrix.calculation.Eq;
import org.ujmp.core.booleanmatrix.calculation.Ge;
import org.ujmp.core.booleanmatrix.calculation.Gt;
import org.ujmp.core.booleanmatrix.calculation.Le;
import org.ujmp.core.booleanmatrix.calculation.Lt;
import org.ujmp.core.booleanmatrix.calculation.Ne;
import org.ujmp.core.booleanmatrix.calculation.Not;
import org.ujmp.core.booleanmatrix.calculation.Or;
import org.ujmp.core.booleanmatrix.calculation.ToBooleanMatrix;
import org.ujmp.core.booleanmatrix.calculation.Xor;
import org.ujmp.core.bytematrix.ByteMatrix;
import org.ujmp.core.bytematrix.calculation.ToByteMatrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.charmatrix.CharMatrix;
import org.ujmp.core.charmatrix.calculation.ToCharMatrix;
import org.ujmp.core.datematrix.DateMatrix;
import org.ujmp.core.datematrix.calculation.ToDateMatrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix;
import org.ujmp.core.doublematrix.calculation.ToDoubleMatrix;
import org.ujmp.core.doublematrix.calculation.basic.Atimes;
import org.ujmp.core.doublematrix.calculation.basic.Divide;
import org.ujmp.core.doublematrix.calculation.basic.Minus;
import org.ujmp.core.doublematrix.calculation.basic.Mtimes;
import org.ujmp.core.doublematrix.calculation.basic.Plus;
import org.ujmp.core.doublematrix.calculation.basic.Times;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Abs;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Exp;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Log;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Log10;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Log2;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Power;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Sign;
import org.ujmp.core.doublematrix.calculation.entrywise.basic.Sqrt;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Eye;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Ones;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Rand;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Randn;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Zeros;
import org.ujmp.core.doublematrix.calculation.entrywise.hyperbolic.Cosh;
import org.ujmp.core.doublematrix.calculation.entrywise.hyperbolic.Sinh;
import org.ujmp.core.doublematrix.calculation.entrywise.hyperbolic.Tanh;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Ceil;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Floor;
import org.ujmp.core.doublematrix.calculation.entrywise.rounding.Round;
import org.ujmp.core.doublematrix.calculation.entrywise.trigonometric.Cos;
import org.ujmp.core.doublematrix.calculation.entrywise.trigonometric.Sin;
import org.ujmp.core.doublematrix.calculation.entrywise.trigonometric.Tan;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Chol;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Eig;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Ginv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Inv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.InvSPD;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Pinv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Princomp;
import org.ujmp.core.doublematrix.calculation.general.decomposition.QR;
import org.ujmp.core.doublematrix.calculation.general.decomposition.SVD;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Solve;
import org.ujmp.core.doublematrix.calculation.general.decomposition.SolveSPD;
import org.ujmp.core.doublematrix.calculation.general.misc.Center;
import org.ujmp.core.doublematrix.calculation.general.misc.DiscretizeToColumns;
import org.ujmp.core.doublematrix.calculation.general.misc.FadeIn;
import org.ujmp.core.doublematrix.calculation.general.misc.FadeOut;
import org.ujmp.core.doublematrix.calculation.general.misc.Normalize;
import org.ujmp.core.doublematrix.calculation.general.misc.Standardize;
import org.ujmp.core.doublematrix.calculation.general.misc.TfIdf;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.AddMissing;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.CountMissing;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.Impute;
import org.ujmp.core.doublematrix.calculation.general.statistical.Corrcoef;
import org.ujmp.core.doublematrix.calculation.general.statistical.Cov;
import org.ujmp.core.doublematrix.calculation.general.statistical.Cumprod;
import org.ujmp.core.doublematrix.calculation.general.statistical.Cumsum;
import org.ujmp.core.doublematrix.calculation.general.statistical.Diff;
import org.ujmp.core.doublematrix.calculation.general.statistical.IndexOfMax;
import org.ujmp.core.doublematrix.calculation.general.statistical.IndexOfMin;
import org.ujmp.core.doublematrix.calculation.general.statistical.Max;
import org.ujmp.core.doublematrix.calculation.general.statistical.Mean;
import org.ujmp.core.doublematrix.calculation.general.statistical.Min;
import org.ujmp.core.doublematrix.calculation.general.statistical.MutualInformation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Prod;
import org.ujmp.core.doublematrix.calculation.general.statistical.Std;
import org.ujmp.core.doublematrix.calculation.general.statistical.Sum;
import org.ujmp.core.doublematrix.calculation.general.statistical.Var;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.floatmatrix.FloatMatrix;
import org.ujmp.core.floatmatrix.calculation.ToFloatMatrix;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasLabel;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.intmatrix.calculation.Discretize;
import org.ujmp.core.intmatrix.calculation.ToIntMatrix;
import org.ujmp.core.io.ExportMatrix;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.longmatrix.LongMatrix;
import org.ujmp.core.longmatrix.calculation.ToLongMatrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.matrix.factory.MatrixFactoryRoot;
import org.ujmp.core.objectmatrix.ObjectMatrix;
import org.ujmp.core.objectmatrix.calculation.Bootstrap;
import org.ujmp.core.objectmatrix.calculation.Convert;
import org.ujmp.core.objectmatrix.calculation.Deletion;
import org.ujmp.core.objectmatrix.calculation.ExtractAnnotation;
import org.ujmp.core.objectmatrix.calculation.Fill;
import org.ujmp.core.objectmatrix.calculation.Flipdim;
import org.ujmp.core.objectmatrix.calculation.IncludeAnnotation;
import org.ujmp.core.objectmatrix.calculation.Replace;
import org.ujmp.core.objectmatrix.calculation.Reshape;
import org.ujmp.core.objectmatrix.calculation.Selection;
import org.ujmp.core.objectmatrix.calculation.Shuffle;
import org.ujmp.core.objectmatrix.calculation.Sortrows;
import org.ujmp.core.objectmatrix.calculation.Squeeze;
import org.ujmp.core.objectmatrix.calculation.Swap;
import org.ujmp.core.objectmatrix.calculation.ToObjectMatrix;
import org.ujmp.core.objectmatrix.calculation.Transpose;
import org.ujmp.core.objectmatrix.calculation.Tril;
import org.ujmp.core.objectmatrix.calculation.Triu;
import org.ujmp.core.objectmatrix.calculation.Unique;
import org.ujmp.core.objectmatrix.calculation.UniqueValueCount;
import org.ujmp.core.objectmatrix.factory.DefaultDenseObjectMatrixFactory;
import org.ujmp.core.setmatrix.DefaultSetMatrix;
import org.ujmp.core.setmatrix.SetMatrix;
import org.ujmp.core.shortmatrix.ShortMatrix;
import org.ujmp.core.shortmatrix.calculation.ToShortMatrix;
import org.ujmp.core.stringmatrix.StringMatrix;
import org.ujmp.core.stringmatrix.calculation.LowerCase;
import org.ujmp.core.stringmatrix.calculation.RemovePunctuation;
import org.ujmp.core.stringmatrix.calculation.RemoveWords;
import org.ujmp.core.stringmatrix.calculation.ReplaceRegex;
import org.ujmp.core.stringmatrix.calculation.Stem;
import org.ujmp.core.stringmatrix.calculation.ToStringMatrix;
import org.ujmp.core.stringmatrix.calculation.UpperCase;
import org.ujmp.core.util.CoordinateIterator;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatrix
extends Number
implements Matrix {
    private static final long serialVersionUID = 5264103919889924711L;
    public static MatrixFactoryRoot factory = new DefaultDenseObjectMatrixFactory();
    private static long runningId = 0L;
    private transient GUIObject guiObject = null;
    private final long id = runningId++;
    private Annotation annotation = null;

    static {
        try {
            runningId = 31L * System.nanoTime() + System.currentTimeMillis();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DecompositionOps.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            UJMPSettings.initialize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            long mem = Runtime.getRuntime().maxMemory();
            if (mem < 133234688L) {
                System.err.println("Available memory is very low: " + mem / 1000000L + "M");
                System.err.println("Invoke Java with the parameter -Xmx512M to increase available memory");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Iterable<long[]> allCoordinates() {
        return new CoordinateIterator(this.getSize());
    }

    @Override
    public final long getCoreObjectId() {
        return this.id;
    }

    @Override
    public double getAsDouble(long ... coordinates) {
        return MathUtil.getDouble(this.getAsObject(coordinates));
    }

    @Override
    public void setAsDouble(double v, long ... coordinates) {
        this.setAsObject(v, coordinates);
    }

    @Override
    public final Object getPreferredObject(long ... coordinates) throws MatrixException {
        return MathUtil.getPreferredObject(this.getAsObject(coordinates));
    }

    @Override
    public final Object getMatrixAnnotation() {
        return this.annotation == null ? null : this.annotation.getMatrixAnnotation();
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public final void setMatrixAnnotation(Object value) {
        if (this.annotation == null) {
            this.annotation = new DefaultAnnotation(this.getSize());
        }
        this.annotation.setMatrixAnnotation(value);
    }

    @Override
    public final Object getAxisAnnotation(int axis, long ... position) {
        return this.annotation == null ? null : this.annotation.getAxisAnnotation(axis, position);
    }

    @Override
    public final Object getAxisAnnotation(int axis) {
        return this.annotation == null ? null : this.annotation.getAxisAnnotation(axis);
    }

    @Override
    public final void setAxisAnnotation(int axis, Object label, long ... position) {
        if (this.annotation == null) {
            this.annotation = new DefaultAnnotation(this.getSize());
        }
        this.annotation.setAxisAnnotation(axis, label, position);
    }

    @Override
    public final void setAxisAnnotation(int axis, Object label) {
        if (this.annotation == null) {
            this.annotation = new DefaultAnnotation(this.getSize());
        }
        this.annotation.setAxisAnnotation(axis, label);
    }

    @Override
    public final GUIObject getGUIObject() {
        if (this.guiObject == null) {
            try {
                Class<?> c = Class.forName("org.ujmp.gui.MatrixGUIObject");
                Constructor<?> con = c.getConstructor(Matrix.class);
                this.guiObject = (GUIObject)con.newInstance(this);
            }
            catch (Exception e) {
                throw new MatrixException("cannot create matrix gui object", e);
            }
        }
        return this.guiObject;
    }

    @Override
    public final boolean containsMissingValues() throws MatrixException {
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (!MathUtil.isNaNOrInfinite(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final double getEuklideanValue() throws MatrixException {
        double sum = 0.0;
        for (long[] c : this.allCoordinates()) {
            sum += Math.pow(this.getAsDouble(c), 2.0);
        }
        return Math.sqrt(sum);
    }

    @Override
    public Matrix clone() {
        return this.copy();
    }

    @Override
    public final Matrix select(Calculation.Ret returnType, long[] ... selection) throws MatrixException {
        return new Selection((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix select(Calculation.Ret returnType, Collection<? extends Number> ... selection) throws MatrixException {
        return new Selection((Matrix)this, selection).calc(returnType);
    }

    @Override
    public Matrix selectRows(Calculation.Ret returnType, long ... rows) throws MatrixException {
        return this.select(returnType, rows, null);
    }

    @Override
    public final Matrix select(Calculation.Ret returnType, String selection) throws MatrixException {
        return new Selection((Matrix)this, selection).calc(returnType);
    }

    @Override
    public Matrix selectColumns(Calculation.Ret returnType, long ... columns) throws MatrixException {
        return this.select(returnType, null, columns);
    }

    @Override
    public final Matrix selectRows(Calculation.Ret returnType, Collection<? extends Number> rows) throws MatrixException {
        return this.select(returnType, rows, null);
    }

    @Override
    public final Matrix selectColumns(Calculation.Ret returnType, Collection<? extends Number> columns) throws MatrixException {
        return this.select(returnType, null, columns);
    }

    @Override
    public Matrix impute(Calculation.Ret returnType, Impute.ImputationMethod method, Object ... parameters) throws MatrixException {
        return new Impute((Matrix)this, method, parameters).calc(returnType);
    }

    @Override
    public Matrix discretize(Calculation.Ret returnType, int dimension, Discretize.DiscretizationMethod method, int numberOfBins) throws MatrixException {
        return new Discretize((Matrix)this, dimension, method, numberOfBins).calc(returnType);
    }

    @Override
    public Matrix indexOfMax(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new IndexOfMax(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix indexOfMin(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new IndexOfMin(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix standardize(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new Standardize(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix normalize(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new Normalize(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix atimes(Calculation.Ret returnType, boolean ignoreNaN, Matrix matrix) throws MatrixException {
        return new Atimes(ignoreNaN, (Matrix)this, matrix).calc(returnType);
    }

    @Override
    public Matrix inv() throws MatrixException {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSymm() throws MatrixException {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() throws MatrixException {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix solveSymm(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix solveSPD(Matrix b) {
        return SolveSPD.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix ginv() throws MatrixException {
        return new Ginv((Matrix)this).calcNew();
    }

    @Override
    public Matrix princomp() throws MatrixException {
        return new Princomp((Matrix)this).calcNew();
    }

    @Override
    public Matrix pinv() throws MatrixException {
        return new Pinv((Matrix)this).calcNew();
    }

    @Override
    public Matrix center(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Center(ignoreNaN, dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix copy() throws MatrixException {
        return Convert.calcNew(this);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public final Matrix convert(ValueType newValueType) throws MatrixException {
        return Convert.calcNew(newValueType, this);
    }

    @Override
    public final Matrix replaceRegex(Calculation.Ret returnType, Pattern search, String replacement) throws MatrixException {
        return new ReplaceRegex((Matrix)this, search, replacement).calc(returnType);
    }

    @Override
    public final Matrix replace(Calculation.Ret returnType, Object search, Object replacement) throws MatrixException {
        return new Replace((Matrix)this, search, replacement).calc(returnType);
    }

    @Override
    public final Matrix replaceRegex(Calculation.Ret returnType, String search, String replacement) throws MatrixException {
        return new ReplaceRegex((Matrix)this, search, replacement).calc(returnType);
    }

    @Override
    public Matrix times(double factor) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.timesScalar.calc((Matrix)this, factor, result);
        return result;
    }

    @Override
    public Matrix times(Matrix m) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.timesMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public Matrix divide(Matrix m) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.divideMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public Matrix divide(double divisor) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.divideScalar.calc((Matrix)this, divisor, result);
        return result;
    }

    @Override
    public Matrix divide(Calculation.Ret returnType, boolean ignoreNaN, double factor) throws MatrixException {
        return new Divide(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public Matrix times(Calculation.Ret returnType, boolean ignoreNaN, double factor) throws MatrixException {
        return new Times(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public Matrix times(Calculation.Ret returnType, boolean ignoreNaN, Matrix factor) throws MatrixException {
        return new Times(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public Matrix divide(Calculation.Ret returnType, boolean ignoreNaN, Matrix factor) throws MatrixException {
        return new Divide(ignoreNaN, (Matrix)this, factor).calc(returnType);
    }

    @Override
    public final Matrix power(Calculation.Ret returnType, double power) throws MatrixException {
        return new Power((Matrix)this, power).calc(returnType);
    }

    @Override
    public final Matrix power(Calculation.Ret returnType, Matrix power) throws MatrixException {
        return new Power((Matrix)this, power).calc(returnType);
    }

    @Override
    public final Matrix gt(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Gt((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix gt(Calculation.Ret returnType, double value) throws MatrixException {
        return new Gt((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix and(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new And((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix and(Calculation.Ret returnType, boolean value) throws MatrixException {
        return new And((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix or(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Or((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix or(Calculation.Ret returnType, boolean value) throws MatrixException {
        return new Or((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix xor(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Xor((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix xor(Calculation.Ret returnType, boolean value) throws MatrixException {
        return new Xor((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix not(Calculation.Ret returnType) throws MatrixException {
        return new Not((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix lt(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Lt((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix lt(Calculation.Ret returnType, double value) throws MatrixException {
        return new Lt((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix ge(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Ge((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix ge(Calculation.Ret returnType, double value) throws MatrixException {
        return new Ge((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix le(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Le((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix le(Calculation.Ret returnType, double value) throws MatrixException {
        return new Le((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix eq(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Eq((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix eq(Calculation.Ret returnType, Object value) throws MatrixException {
        return new Eq((Matrix)this, value).calc(returnType);
    }

    @Override
    public final Matrix ne(Calculation.Ret returnType, Matrix matrix) throws MatrixException {
        return new Ne((Matrix)this, matrix).calc(returnType);
    }

    @Override
    public final Matrix ne(Calculation.Ret returnType, Object value) throws MatrixException {
        return new Ne((Matrix)this, value).calc(returnType);
    }

    @Override
    public long getValueCount() {
        return Coordinates.product(this.getSize());
    }

    @Override
    public final long[] getCoordinatesOfMaximum() throws MatrixException {
        double max = -1.7976931348623157E308;
        long[] maxc = Coordinates.copyOf(this.getSize());
        Arrays.fill(maxc, -1L);
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (!(v > max)) continue;
            max = v;
            maxc = Coordinates.copyOf(c);
        }
        return maxc;
    }

    @Override
    public final long[] getCoordinatesOfMinimum() throws MatrixException {
        double min = Double.MAX_VALUE;
        long[] minc = Coordinates.copyOf(this.getSize());
        Arrays.fill(minc, -1L);
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (!(v < min)) continue;
            min = v;
            minc = Coordinates.copyOf(c);
        }
        return minc;
    }

    @Override
    public Iterable<long[]> selectedCoordinates(String selection) throws MatrixException {
        return this.select(Calculation.Ret.LINK, selection).allCoordinates();
    }

    @Override
    public Iterable<long[]> selectedCoordinates(long[] ... selection) throws MatrixException {
        return this.select(Calculation.Ret.LINK, selection).allCoordinates();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public Iterable<long[]> nonZeroCoordinates() {
        return this.availableCoordinates();
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return this.allCoordinates();
    }

    @Override
    public double[][] toDoubleArray() throws MatrixException {
        int rows = (int)this.getRowCount();
        int columns = (int)this.getColumnCount();
        double[][] values = new double[rows][columns];
        if (this instanceof HasColumnMajorDoubleArray1D) {
            double[] m = ((HasColumnMajorDoubleArray1D)((Object)this)).getColumnMajorDoubleArray1D();
            int r = 0;
            while (r < rows) {
                double[] valuesr = values[r];
                int c = 0;
                while (c < columns) {
                    valuesr[c] = m[c * rows + r];
                    ++c;
                }
                ++r;
            }
        } else if (this instanceof HasRowMajorDoubleArray2D) {
            double[][] m = ((HasRowMajorDoubleArray2D)((Object)this)).getRowMajorDoubleArray2D();
            int r = 0;
            while (r < rows) {
                System.arraycopy(m[r], 0, values[r], 0, columns);
                ++r;
            }
        } else if (this instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D m = (DenseDoubleMatrix2D)((Object)this);
            int r = 0;
            while (r < rows) {
                double[] valuesr = values[r];
                int c = 0;
                while (c < columns) {
                    valuesr[c] = m.getDouble(r, c);
                    ++c;
                }
                ++r;
            }
        } else {
            int r = 0;
            while (r < rows) {
                double[] valuesr = values[r];
                int c = 0;
                while (c < columns) {
                    valuesr[c] = this.getAsDouble(r, c);
                    ++c;
                }
                ++r;
            }
        }
        return values;
    }

    @Override
    public Object[][] toObjectArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        Object[][] values = new Object[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsObject(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public int[][] toIntArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        int[][] values = new int[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsInt(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public long[][] toLongArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        long[][] values = new long[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsLong(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public short[][] toShortArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        short[][] values = new short[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsShort(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public char[][] toCharArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        char[][] values = new char[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsChar(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public String[][] toStringArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        String[][] values = new String[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsString(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public byte[][] toByteArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        byte[][] values = new byte[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsByte(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public boolean[][] toBooleanArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        boolean[][] values = new boolean[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsBoolean(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public float[][] toFloatArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        float[][] values = new float[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsFloat(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public Date[][] toDateArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        Date[][] values = new Date[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsDate(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public BigDecimal[][] toBigDecimalArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        BigDecimal[][] values = new BigDecimal[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsBigDecimal(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public BigInteger[][] toBigIntegerArray() throws MatrixException {
        int r = (int)this.getRowCount();
        int c = (int)this.getColumnCount();
        BigInteger[][] values = new BigInteger[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                values[i][j] = this.getAsBigInteger(i, j);
                ++j;
            }
            ++i;
        }
        return values;
    }

    @Override
    public final Matrix sqrt(Calculation.Ret returnType) throws MatrixException {
        return new Sqrt((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix round(Calculation.Ret returnType) throws MatrixException {
        return new Round((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix ceil(Calculation.Ret returnType) throws MatrixException {
        return new Ceil((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix extractAnnotation(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new ExtractAnnotation((Matrix)this, dimension).calc(returnType);
    }

    @Override
    public final Matrix includeAnnotation(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new IncludeAnnotation((Matrix)this, dimension).calc(returnType);
    }

    @Override
    public final Matrix floor(Calculation.Ret returnType) throws MatrixException {
        return new Floor((Matrix)this).calc(returnType);
    }

    @Override
    public final JFrame showGUI() {
        try {
            Class<?> c = Class.forName("org.ujmp.gui.util.FrameManager");
            Method method = c.getMethod("showFrame", GUIObject.class);
            Object o = method.invoke(null, this.getGUIObject());
            return (JFrame)o;
        }
        catch (Exception e) {
            throw new MatrixException("cannot show GUI", e);
        }
    }

    @Override
    public void notifyGUIObject() {
        if (this.guiObject != null) {
            this.guiObject.fireValueChanged();
        }
    }

    @Override
    public Matrix mtimes(Matrix matrix) throws MatrixException {
        Matrix result = MatrixFactory.like(this, this.getRowCount(), matrix.getColumnCount());
        Matrix.mtimes.calc(this, matrix, result);
        return result;
    }

    @Override
    public Matrix mtimes(Calculation.Ret returnType, boolean ignoreNaN, Matrix matrix) throws MatrixException {
        return new Mtimes(ignoreNaN, (Matrix)this, matrix).calc(returnType);
    }

    @Override
    public Matrix mtimes(double value) throws MatrixException {
        return this.times(value);
    }

    @Override
    public Matrix mtimes(Calculation.Ret returnType, boolean ignoreNaN, double value) throws MatrixException {
        return this.times(returnType, ignoreNaN, value);
    }

    @Override
    public boolean getAsBoolean(long ... coordinates) throws MatrixException {
        return MathUtil.getBoolean(this.getAsObject(coordinates));
    }

    @Override
    public void setAsBoolean(boolean value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value ? 1.0 : 0.0, coordinates);
    }

    @Override
    public int getAsInt(long ... coordinates) throws MatrixException {
        return (int)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsInt(int value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public byte getAsByte(long ... coordinates) throws MatrixException {
        return (byte)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsByte(byte value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public char getAsChar(long ... coordinates) throws MatrixException {
        return (char)this.getAsDouble(coordinates);
    }

    @Override
    public BigInteger getAsBigInteger(long ... coordinates) throws MatrixException {
        return MathUtil.getBigInteger(this.getAsObject(coordinates));
    }

    @Override
    public BigDecimal getAsBigDecimal(long ... coordinates) throws MatrixException {
        return MathUtil.getBigDecimal(this.getAsObject(coordinates));
    }

    @Override
    public void setAsChar(char value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public void setAsBigDecimal(BigDecimal value, long ... coordinates) throws MatrixException {
        if (value == null) {
            this.setAsDouble(Double.NaN, coordinates);
        } else {
            this.setAsDouble(value.doubleValue(), coordinates);
        }
    }

    @Override
    public void setAsBigInteger(BigInteger value, long ... coordinates) throws MatrixException {
        if (value == null) {
            this.setAsLong(0L, coordinates);
        } else {
            this.setAsLong(value.longValue(), coordinates);
        }
    }

    @Override
    public float getAsFloat(long ... coordinates) throws MatrixException {
        return (float)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsFloat(float value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public short getAsShort(long ... coordinates) throws MatrixException {
        return (short)this.getAsDouble(coordinates);
    }

    @Override
    public Matrix getAsMatrix(long ... coordinates) throws MatrixException {
        return MathUtil.getMatrix(this.getAsObject(coordinates));
    }

    @Override
    public void setAsMatrix(Matrix m, long ... coordinates) throws MatrixException {
        this.setAsObject(m, coordinates);
    }

    @Override
    public void setAsShort(short value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public long getAsLong(long ... coordinates) throws MatrixException {
        return (long)this.getAsDouble(coordinates);
    }

    @Override
    public void setAsLong(long value, long ... coordinates) throws MatrixException {
        this.setAsDouble(value, coordinates);
    }

    @Override
    public Date getAsDate(long ... coordinates) throws MatrixException {
        return MathUtil.getDate(this.getAsObject(coordinates));
    }

    @Override
    public void setAsDate(Date date, long ... coordinates) throws MatrixException {
        this.setAsObject(date, coordinates);
    }

    @Override
    public final Matrix delete(Calculation.Ret returnType, String selection) throws MatrixException {
        return new Deletion((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix delete(Calculation.Ret returnType, Collection<? extends Number> ... selection) throws MatrixException {
        return new Deletion((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix delete(Calculation.Ret returnType, long[] ... selection) throws MatrixException {
        return new Deletion((Matrix)this, selection).calc(returnType);
    }

    @Override
    public final Matrix deleteRows(Calculation.Ret returnType, long ... rows) throws MatrixException {
        return this.delete(returnType, rows, new long[0]);
    }

    @Override
    public final Matrix deleteRows(Calculation.Ret returnType, Collection<? extends Number> rows) throws MatrixException {
        return this.delete(returnType, rows, new ArrayList());
    }

    @Override
    public final Matrix deleteColumns(Calculation.Ret returnType, Collection<? extends Number> columns) throws MatrixException {
        return this.delete(returnType, new ArrayList(), columns);
    }

    @Override
    public final Matrix deleteColumns(Calculation.Ret returnType, long ... columns) throws MatrixException {
        return this.delete(returnType, new long[0], columns);
    }

    @Override
    public Matrix minus(Calculation.Ret returnType, boolean ignoreNaN, double v) throws MatrixException {
        return new Minus(ignoreNaN, (Matrix)this, v).calc(returnType);
    }

    @Override
    public Matrix minus(Calculation.Ret returnType, boolean ignoreNaN, Matrix m) throws MatrixException {
        return new Minus(ignoreNaN, (Matrix)this, m).calc(returnType);
    }

    @Override
    public Matrix plus(Calculation.Ret returnType, boolean ignoreNaN, double v) throws MatrixException {
        return new Plus(ignoreNaN, (Matrix)this, v).calc(returnType);
    }

    @Override
    public Matrix plus(Calculation.Ret returnType, boolean ignoreNaN, Matrix m) throws MatrixException {
        return new Plus(ignoreNaN, (Matrix)this, m).calc(returnType);
    }

    @Override
    public Matrix transpose() throws MatrixException {
        Matrix result = null;
        try {
            result = (Matrix)this.getClass().getConstructor(long[].class).newInstance(new Object[]{Coordinates.transpose(this.getSize())});
        }
        catch (Exception e) {
            result = Matrix.factory.zeros(Coordinates.transpose(this.getSize()));
        }
        Matrix.transpose.calc(this, result);
        return result;
    }

    @Override
    public Matrix transpose(Calculation.Ret returnType) throws MatrixException {
        return new Transpose((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix mean(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Mean(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix var(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Var(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix std(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Std(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public long getColumnCount() {
        return this.getSize(1);
    }

    @Override
    public long getRowCount() {
        return this.getSize(0);
    }

    @Override
    public long getZCount() {
        return this.getSize(2);
    }

    @Override
    public final long getSize(int dimension) {
        return this.getSize()[dimension];
    }

    @Override
    public Matrix prod(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Prod(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix diff(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Diff(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix sum(Calculation.Ret returnType, int dimension, boolean ignoreNaN) throws MatrixException {
        return new Sum(dimension, ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix sign(Calculation.Ret returnType) throws MatrixException {
        return new Sign((Matrix)this).calc(returnType);
    }

    @Override
    public String toString() {
        return UJMPFormat.getMultiLineInstance().format(this);
    }

    @Override
    public final int getDimensionCount() {
        return this.getSize().length;
    }

    @Override
    public final Matrix ones(Calculation.Ret ret) throws MatrixException {
        return new Ones((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix fill(Calculation.Ret ret, Object value) throws MatrixException {
        return new Fill((Matrix)this, value).calc(ret);
    }

    @Override
    public final Matrix zeros(Calculation.Ret ret) throws MatrixException {
        return new Zeros((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix eye(Calculation.Ret ret) throws MatrixException {
        return new Eye((Matrix)this).calc(ret);
    }

    @Override
    public Matrix plus(double value) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.plusScalar.calc((Matrix)this, value, result);
        return result;
    }

    @Override
    public Matrix plus(Matrix m) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.plusMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public Matrix minus(double value) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.minusScalar.calc((Matrix)this, value, result);
        return result;
    }

    @Override
    public Matrix minus(Matrix m) throws MatrixException {
        Matrix result = MatrixFactory.like(this);
        Matrix.minusMatrix.calc(this, m, result);
        return result;
    }

    @Override
    public void clear() {
        new Zeros((Matrix)this).calc(Calculation.Ret.ORIG);
    }

    @Override
    public final Matrix rand(Calculation.Ret ret) throws MatrixException {
        return new Rand((Matrix)this).calc(ret);
    }

    @Override
    public final Matrix randn(Calculation.Ret ret) throws MatrixException {
        return new Randn((Matrix)this).calc(ret);
    }

    @Override
    public final int compareTo(Matrix m) {
        double v1 = this.getMeanValue();
        double v2 = m.getMeanValue();
        return new Double(v1).compareTo(v2);
    }

    @Override
    public int rank() throws MatrixException {
        int rank = 0;
        Matrix[] usv = this.svd();
        Matrix s = usv[1];
        int i = (int)Math.min(s.getSize(0), s.getSize(1));
        while (--i >= 0) {
            long[] lArray = new long[]{i, i};
            if (!(Math.abs(s.getAsDouble(lArray)) > UJMPSettings.getTolerance())) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public final boolean isSPD() {
        if (this.getDimensionCount() != 2) {
            return false;
        }
        if (!this.isSquare()) {
            return false;
        }
        return new Chol.CholMatrix(this).isSPD();
    }

    @Override
    public final boolean isSymmetric() {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("only supported for 2d matrices");
        }
        if (this.isSquare()) {
            return false;
        }
        if (this instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D m = (DenseDoubleMatrix2D)((Object)this);
            long r = this.getRowCount();
            while (--r >= 0L) {
                long c = this.getColumnCount();
                while (--c >= 0L) {
                    if (m.getDouble(r, c) == m.getDouble(c, r)) continue;
                    return false;
                }
            }
        } else {
            for (long[] c : this.availableCoordinates()) {
                Object o2;
                Object o1 = this.getAsObject(c);
                if (MathUtil.equals(o1, o2 = this.getAsObject(Coordinates.transpose(c)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() throws MatrixException {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsDouble(c) == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Matrix abs(Calculation.Ret returnType) throws MatrixException {
        return new Abs((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix log(Calculation.Ret returnType) throws MatrixException {
        return new Log((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix exp(Calculation.Ret returnType) throws MatrixException {
        return new Exp((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix sortrows(Calculation.Ret returnType, long column, boolean reverse) throws MatrixException {
        return new Sortrows((Matrix)this, column, reverse).calc(returnType);
    }

    @Override
    public final Matrix cumsum(boolean ignoreNaN) throws MatrixException {
        return new Cumsum((Matrix)this, ignoreNaN).calcNew();
    }

    @Override
    public final Matrix cumprod(boolean ignoreNaN) throws MatrixException {
        return new Cumprod((Matrix)this, ignoreNaN).calcNew();
    }

    @Override
    public final Matrix log2(Calculation.Ret returnType) throws MatrixException {
        return new Log2((Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix log10(Calculation.Ret returnType) throws MatrixException {
        return new Log10((Matrix)this).calc(returnType);
    }

    @Override
    public final boolean isDiagonal() throws MatrixException {
        if (!this.isSquare()) {
            return false;
        }
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (v == 0.0) continue;
            int i = 1;
            while (i < c.length) {
                if (c[i - 1] != c[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public final boolean isSquare() {
        return this.getDimensionCount() == 2 && this.getColumnCount() == this.getRowCount();
    }

    @Override
    public double euklideanDistanceTo(Matrix m, boolean ignoreNaN) throws MatrixException {
        return this.minkowskiDistanceTo(m, 2.0, ignoreNaN);
    }

    @Override
    public double det() throws MatrixException {
        if (this.getDimensionCount() != 2 || !this.isSquare()) {
            throw new MatrixException("only supported for 2d square matrices");
        }
        return new LU.LUMatrix(this).det();
    }

    @Override
    public boolean isSingular() throws MatrixException {
        if (this.getDimensionCount() != 2 || !this.isSquare()) {
            throw new MatrixException("only supported for 2d square matrices");
        }
        return !new LU.LUMatrix(this).isNonsingular();
    }

    @Override
    public double manhattenDistanceTo(Matrix m, boolean ignoreNaN) throws MatrixException {
        return this.minkowskiDistanceTo(m, 1.0, ignoreNaN);
    }

    @Override
    public double minkowskiDistanceTo(Matrix m, double p, boolean ignoreNaN) throws MatrixException {
        double sum = 0.0;
        if (ignoreNaN) {
            for (long[] c : this.allCoordinates()) {
                sum += MathUtil.ignoreNaN(Math.pow(Math.abs(this.getAsDouble(c) - m.getAsDouble(c)), p));
            }
        } else {
            for (long[] c : this.allCoordinates()) {
                sum += Math.pow(Math.abs(this.getAsDouble(c) - m.getAsDouble(c)), p);
            }
        }
        return Math.pow(sum, 1.0 / p);
    }

    @Override
    public double chebyshevDistanceTo(Matrix m, boolean ignoreNaN) throws MatrixException {
        double max = 0.0;
        if (ignoreNaN) {
            for (long[] c : this.allCoordinates()) {
                double v = MathUtil.ignoreNaN(Math.abs(this.getAsDouble(c) - m.getAsDouble(c)));
                double d = max = v > max ? v : max;
            }
        } else {
            for (long[] c : this.allCoordinates()) {
                double v = Math.abs(this.getAsDouble(c) - m.getAsDouble(c));
                double d = max = v > max ? v : max;
            }
        }
        return max;
    }

    @Override
    public Matrix min(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new Min(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix max(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new Max(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix addMissing(Calculation.Ret returnType, int dimension, double ... percentMissing) throws MatrixException {
        return new AddMissing(dimension, (Matrix)this, percentMissing).calc(returnType);
    }

    @Override
    public Matrix countMissing(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new CountMissing(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public final boolean isScalar() {
        return Coordinates.product(this.getSize()) == 1L;
    }

    @Override
    public final boolean isRowVector() {
        return this.getColumnCount() == 1L && this.getRowCount() != 1L;
    }

    @Override
    public final boolean isColumnVector() {
        return this.getColumnCount() != 1L && this.getRowCount() == 1L;
    }

    @Override
    public final boolean isMultidimensionalMatrix() {
        return this.getColumnCount() != 1L && this.getRowCount() != 1L;
    }

    @Override
    public Matrix sinh(Calculation.Ret returnType) throws MatrixException {
        return new Sinh((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix cosh(Calculation.Ret returnType) throws MatrixException {
        return new Cosh((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix tanh(Calculation.Ret returnType) throws MatrixException {
        return new Tanh((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix sin(Calculation.Ret returnType) throws MatrixException {
        return new Sin((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix cos(Calculation.Ret returnType) throws MatrixException {
        return new Cos((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix tril(Calculation.Ret returnType, int k) throws MatrixException {
        return new Tril((Matrix)this, k).calc(returnType);
    }

    @Override
    public Matrix triu(Calculation.Ret returnType, int k) throws MatrixException {
        return new Triu((Matrix)this, k).calc(returnType);
    }

    @Override
    public Matrix tan(Calculation.Ret returnType) throws MatrixException {
        return new Tan((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix cov(Calculation.Ret returnType, boolean ignoreNaN) throws MatrixException {
        return new Cov(ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix corrcoef(Calculation.Ret returnType, boolean ignoreNaN) throws MatrixException {
        return new Corrcoef(ignoreNaN, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix mutualInf(Calculation.Ret returnType) throws MatrixException {
        return new MutualInformation((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix pairedTTest(Calculation.Ret returnType) throws MatrixException {
        try {
            Class<?> c = Class.forName("org.ujmp.commonsmath.PairedTTest");
            Constructor<?> con = c.getConstructor(Matrix.class);
            Calculation calc = (Calculation)con.newInstance(this);
            return calc.calc(returnType);
        }
        catch (Exception e) {
            throw new MatrixException("could not calculate", e);
        }
    }

    @Override
    public Matrix bootstrap(Calculation.Ret returnType) throws MatrixException {
        return new Bootstrap((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix lowerCase(Calculation.Ret returnType) throws MatrixException {
        return new LowerCase((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix upperCase(Calculation.Ret returnType) throws MatrixException {
        return new UpperCase((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix tfIdf(boolean calculateTf, boolean calculateIdf, boolean normalize) throws MatrixException {
        return new TfIdf((Matrix)this, calculateTf, calculateIdf, normalize).calc(Calculation.Ret.NEW);
    }

    @Override
    public Matrix removePunctuation(Calculation.Ret ret) throws MatrixException {
        return new RemovePunctuation((Matrix)this).calc(ret);
    }

    @Override
    public Matrix stem(Calculation.Ret ret) throws MatrixException {
        return new Stem((Matrix)this).calc(ret);
    }

    @Override
    public Matrix removeWords(Calculation.Ret ret, Collection<String> words) throws MatrixException {
        return new RemoveWords((Matrix)this, words).calc(ret);
    }

    @Override
    public Matrix unique(Calculation.Ret returnType) throws MatrixException {
        return new Unique((Matrix)this).calc(returnType);
    }

    @Override
    public Matrix uniqueValueCount(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new UniqueValueCount((Matrix)this, dimension).calc(returnType);
    }

    @Override
    public Matrix bootstrap(Calculation.Ret returnType, int count) throws MatrixException {
        return new Bootstrap((Matrix)this, count).calc(returnType);
    }

    @Override
    public Matrix transpose(Calculation.Ret returnType, int dimension1, int dimension2) throws MatrixException {
        return new Transpose((Matrix)this, dimension1, dimension2).calc(returnType);
    }

    @Override
    public Matrix swap(Calculation.Ret returnType, int dimension, long pos1, long pos2) throws MatrixException {
        return new Swap(dimension, pos1, pos2, (Matrix)this).calc(returnType);
    }

    @Override
    public Matrix flipdim(Calculation.Ret returnType, int dimension) throws MatrixException {
        return new Flipdim(dimension, (Matrix)this).calc(returnType);
    }

    @Override
    public final Matrix shuffle(Calculation.Ret returnType) throws MatrixException {
        return new Shuffle((Matrix)this).calc(returnType);
    }

    @Override
    public final double trace() throws MatrixException {
        double sum = 0.0;
        long i = Math.min(this.getRowCount(), this.getColumnCount());
        while (--i >= 0L) {
            sum += this.getAsDouble(i, i);
        }
        return sum;
    }

    @Override
    public final void exportToFile(File file, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(file, (Matrix)this, parameters);
    }

    @Override
    public final void exportToClipboard(FileFormat format, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toClipboard(format, this, parameters);
    }

    @Override
    public final void exportToFile(String file, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(file, (Matrix)this, parameters);
    }

    @Override
    public final void exportToFile(FileFormat format, String filename, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(format, filename, (Matrix)this, parameters);
    }

    @Override
    public final void exportToFile(FileFormat format, File file, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(format, file, (Matrix)this, parameters);
    }

    @Override
    public final void exportToStream(FileFormat format, OutputStream outputStream, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toStream(format, outputStream, this, parameters);
    }

    @Override
    public final void exportToWriter(FileFormat format, Writer writer, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toWriter(format, writer, this, parameters);
    }

    @Override
    public final void setLabel(String label) {
        this.setMatrixAnnotation(label);
    }

    @Override
    public final String getLabel() {
        Object o = this.getMatrixAnnotation();
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof HasLabel) {
            return ((HasLabel)o).getLabel();
        }
        return o.toString();
    }

    @Override
    public void setAsString(String string, long ... coordinates) throws MatrixException {
        this.setAsObject(string, coordinates);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getAsString(long ... coordinates) throws MatrixException {
        return StringUtil.convert(this.getAsObject(coordinates));
    }

    @Override
    public final double getMaxValue() throws MatrixException {
        return Max.calc(this);
    }

    @Override
    public final double getMinValue() throws MatrixException {
        return Min.calc(this);
    }

    @Override
    public final double getMeanValue() throws MatrixException {
        return Mean.calc(this);
    }

    @Override
    public final double getStdValue() throws MatrixException {
        return this.std(Calculation.Ret.NEW, Integer.MAX_VALUE, true).getEuklideanValue();
    }

    @Override
    public final double getValueSum() throws MatrixException {
        double sum = 0.0;
        for (long[] c : this.allCoordinates()) {
            sum += this.getAsDouble(c);
        }
        return sum;
    }

    @Override
    public final double getAbsoluteValueSum() throws MatrixException {
        double sum = 0.0;
        for (long[] c : this.allCoordinates()) {
            sum += Math.abs(this.getAsDouble(c));
        }
        return sum;
    }

    @Override
    public final String getColumnLabel(long col) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[1] = col;
        return StringUtil.convert(this.getAxisAnnotation(0, lArray));
    }

    @Override
    public final String getRowLabel(long row) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[0] = row;
        return StringUtil.convert(this.getAxisAnnotation(1, lArray));
    }

    @Override
    public final long getRowForLabel(Object object) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        return this.getPositionForLabel(1, object)[0];
    }

    @Override
    public final long getColumnForLabel(Object object) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        return this.getPositionForLabel(0, object)[1];
    }

    @Override
    public final long[] getPositionForLabel(int dimension, Object label) {
        if (this.annotation == null) {
            long[] t = Coordinates.copyOf(this.getSize());
            t[dimension] = -1L;
            return t;
        }
        return this.annotation.getPositionForLabel(dimension, label);
    }

    @Override
    public final Object getRowObject(long row) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[0] = row;
        return this.getAxisAnnotation(1, lArray);
    }

    @Override
    public final Object getColumnObject(long col) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[1] = col;
        return this.getAxisAnnotation(0, lArray);
    }

    @Override
    public final void setColumnLabel(long col, String label) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[1] = col;
        this.setAxisAnnotation(0, label, lArray);
    }

    @Override
    public final void setRowLabel(long row, String label) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[0] = row;
        this.setAxisAnnotation(1, label, lArray);
    }

    @Override
    public final void setRowObject(long row, Object label) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[0] = row;
        this.setAxisAnnotation(1, label, lArray);
    }

    @Override
    public final void setColumnObject(long col, Object label) {
        if (this.getDimensionCount() != 2) {
            throw new MatrixException("This function is only supported for 2D matrices");
        }
        long[] lArray = new long[2];
        lArray[1] = col;
        this.setAxisAnnotation(0, label, lArray);
    }

    @Override
    public final double getAbsoluteValueMean() throws MatrixException {
        return this.getAbsoluteValueSum() / (double)this.getValueCount();
    }

    @Override
    public final Matrix toRowVector(Calculation.Ret returnType) throws MatrixException {
        if (this.isRowVector()) {
            return this;
        }
        if (this.isColumnVector()) {
            return this.transpose(returnType);
        }
        return this.reshape(returnType, Coordinates.product(this.getSize()), 1L);
    }

    @Override
    public final Matrix toColumnVector(Calculation.Ret returnType) throws MatrixException {
        if (this.isColumnVector()) {
            return this;
        }
        if (this.isRowVector()) {
            return this.transpose(returnType);
        }
        return this.reshape(returnType, 1L, (int)Coordinates.product(this.getSize()));
    }

    @Override
    public Matrix replaceMissingBy(Matrix matrix) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(this.getSize());
        for (long[] c : this.allCoordinates()) {
            double v = this.getAsDouble(c);
            if (MathUtil.isNaNOrInfinite(v)) {
                ret.setAsDouble(matrix.getAsDouble(c), c);
                continue;
            }
            ret.setAsDouble(this.getAsDouble(c), c);
        }
        return ret;
    }

    @Override
    public final Matrix deleteColumnsWithMissingValues(Calculation.Ret returnType) throws MatrixException {
        Matrix mv = this.countMissing(Calculation.Ret.NEW, 0);
        ArrayList<Long> sel = new ArrayList<Long>();
        long c = 0L;
        while (c < mv.getColumnCount()) {
            if (mv.getAsDouble(0L, c) == 0.0) {
                sel.add(c);
            }
            ++c;
        }
        long[] longsel = new long[sel.size()];
        int i = sel.size();
        while (--i >= 0) {
            longsel[i] = (Long)sel.get(i);
        }
        return this.selectColumns(returnType, longsel);
    }

    @Override
    public final Matrix deleteRowsWithMissingValues(Calculation.Ret returnType, long threshold) throws MatrixException {
        Matrix mv = this.countMissing(Calculation.Ret.NEW, 1);
        ArrayList<Long> sel = new ArrayList<Long>();
        long r = 0L;
        while (r < mv.getRowCount()) {
            if (mv.getAsLong(r, 0L) < threshold) {
                sel.add(r);
            }
            ++r;
        }
        if (sel.isEmpty()) {
            return MatrixFactory.emptyMatrix();
        }
        return this.selectRows(returnType, sel);
    }

    @Override
    public final Matrix appendHorizontally(Matrix m) throws MatrixException {
        return this.append(1, m);
    }

    @Override
    public Iterable<Object> allValues() {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    private Iterator<long[]> it;
                    {
                        this.it = AbstractMatrix.this.allCoordinates().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Object next() {
                        return AbstractMatrix.this.getAsObject(this.it.next());
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
    }

    @Override
    public final Matrix appendVertically(Matrix m) throws MatrixException {
        return this.append(0, m);
    }

    @Override
    public final Matrix append(int dimension, Matrix m) throws MatrixException {
        return MatrixFactory.concat(dimension, this, m);
    }

    @Override
    public final Matrix discretizeToColumns(long column) throws MatrixException {
        return new DiscretizeToColumns((Matrix)this, false, column).calc(Calculation.Ret.NEW);
    }

    @Override
    public final Matrix subMatrix(Calculation.Ret returnType, long startRow, long startColumn, long endRow, long endColumn) throws MatrixException {
        long[] rows = MathUtil.sequenceLong(startRow, endRow);
        long[] columns = MathUtil.sequenceLong(startColumn, endColumn);
        return this.select(returnType, rows, columns);
    }

    @Override
    public Matrix[] svd() throws MatrixException {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] eig() throws MatrixException {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] eigSymm() throws MatrixException {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] qr() throws MatrixException {
        return QR.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] lu() throws MatrixException {
        return LU.INSTANCE.calc(this);
    }

    @Override
    public Matrix chol() throws MatrixException {
        return Chol.INSTANCE.calc(this);
    }

    @Override
    public final String exportToString(FileFormat format, Object ... parameters) throws MatrixException, IOException {
        return ExportMatrix.toString(format, this, parameters);
    }

    @Override
    public void setSize(long ... size) {
        throw new MatrixException("operation not possible: cannot change size of matrix");
    }

    @Override
    public final Matrix reshape(Calculation.Ret returnType, long ... newSize) {
        return new Reshape((Matrix)this, newSize).calc(returnType);
    }

    @Override
    public final Matrix squeeze(Calculation.Ret returnType) {
        return new Squeeze((Matrix)this).calc(returnType);
    }

    @Override
    public final double doubleValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsDouble(0L, 0L);
        }
        return this.getMeanValue();
    }

    @Override
    public final int intValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsInt(0L, 0L);
        }
        return (int)this.getMeanValue();
    }

    @Override
    public final char charValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsChar(0L, 0L);
        }
        return (char)this.getMeanValue();
    }

    @Override
    public final BigInteger bigIntegerValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsBigInteger(0L, 0L);
        }
        return BigInteger.valueOf((long)this.getMeanValue());
    }

    @Override
    public final BigDecimal bigDecimalValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsBigDecimal(0L, 0L);
        }
        return BigDecimal.valueOf(this.getMeanValue());
    }

    @Override
    public final Matrix fadeIn(Calculation.Ret ret, int dimension) throws MatrixException {
        return new FadeIn(dimension, (Matrix)this).calc(ret);
    }

    @Override
    public final Matrix fadeOut(Calculation.Ret ret, int dimension) throws MatrixException {
        return new FadeOut(dimension, (Matrix)this).calc(ret);
    }

    @Override
    public final float floatValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsFloat(0L, 0L);
        }
        return (float)this.getMeanValue();
    }

    @Override
    public final long longValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsLong(0L, 0L);
        }
        return (long)this.getMeanValue();
    }

    @Override
    public final Date dateValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsDate(0L, 0L);
        }
        return MathUtil.getDate(this.getMeanValue());
    }

    @Override
    public final boolean booleanValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsBoolean(0L, 0L);
        }
        return this.getMeanValue() != 0.0;
    }

    @Override
    public final String stringValue() throws MatrixException {
        if (this.isScalar()) {
            return this.getAsString(0L, 0L);
        }
        return this.toString();
    }

    @Override
    public final double getRMS() throws MatrixException {
        double sum = 0.0;
        long count = 0L;
        for (long[] c : this.allCoordinates()) {
            sum += Math.pow(this.getAsDouble(c), 2.0);
            ++count;
        }
        return Math.sqrt(sum /= (double)count);
    }

    @Override
    public final Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public final void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public final boolean equalsAnnotation(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Matrix) {
            Matrix m = (Matrix)o;
            Annotation a1 = this.getAnnotation();
            Annotation a2 = m.getAnnotation();
            if (a1 != null ? !a1.equals(a2) : a2 != null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean equals(Object o) {
        return this.equalsContent(o) && this.equalsAnnotation(o);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean equalsContent(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o instanceof Matrix) {
                Matrix m = (Matrix)o;
                if (!Coordinates.equals(this.getSize(), m.getSize())) {
                    return false;
                }
                if (this.isSparse() && m.isSparse()) {
                    Object o2;
                    Object o1;
                    for (long[] c : this.availableCoordinates()) {
                        o1 = this.getAsObject(c);
                        o2 = m.getAsObject(c);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (o1 != null && o2 != null) {
                            if (o1.equals(o2)) continue;
                            return false;
                        }
                        return false;
                    }
                    for (long[] c : m.availableCoordinates()) {
                        o1 = this.getAsObject(c);
                        o2 = m.getAsObject(c);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (o1 != null && o2 != null) {
                            if (o1.equals(o2)) continue;
                            return false;
                        }
                        return false;
                    }
                } else {
                    for (long[] c : this.allCoordinates()) {
                        Object o1 = this.getAsObject(c);
                        Object o2 = m.getAsObject(c);
                        if (o1 == null && o2 != null || o1 != null && o2 == null) {
                            return false;
                        }
                        if (!(o1 != null && o2 != null ? (o1.getClass().equals(o2.getClass()) ? !o1.equals(o2) : !MathUtil.equals(o1, o2)) : o1 != null || o2 != null)) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new MatrixException("could not compare", e);
        }
    }

    @Override
    public final BooleanMatrix toBooleanMatrix() {
        return new ToBooleanMatrix((Matrix)this).calcLink();
    }

    @Override
    public final ByteMatrix toByteMatrix() {
        return new ToByteMatrix((Matrix)this).calcLink();
    }

    @Override
    public final CharMatrix toCharMatrix() {
        return new ToCharMatrix((Matrix)this).calcLink();
    }

    @Override
    public final DateMatrix toDateMatrix() {
        return new ToDateMatrix((Matrix)this).calcLink();
    }

    @Override
    public final DoubleMatrix toDoubleMatrix() {
        return new ToDoubleMatrix((Matrix)this).calcLink();
    }

    @Override
    public final FloatMatrix toFloatMatrix() {
        return new ToFloatMatrix((Matrix)this).calcLink();
    }

    @Override
    public final IntMatrix toIntMatrix() {
        return new ToIntMatrix((Matrix)this).calcLink();
    }

    @Override
    public final LongMatrix toLongMatrix() {
        return new ToLongMatrix((Matrix)this).calcLink();
    }

    @Override
    public final BigDecimalMatrix toBigDecimalMatrix() {
        return new ToBigDecimalMatrix((Matrix)this).calcLink();
    }

    @Override
    public final BigIntegerMatrix toBigIntegerMatrix() {
        return new ToBigIntegerMatrix((Matrix)this).calcLink();
    }

    @Override
    public final ObjectMatrix toObjectMatrix() {
        return new ToObjectMatrix((Matrix)this).calcLink();
    }

    @Override
    public final ShortMatrix toShortMatrix() {
        return new ToShortMatrix((Matrix)this).calcLink();
    }

    @Override
    public final StringMatrix toStringMatrix() {
        return new ToStringMatrix((Matrix)this).calcLink();
    }

    @Override
    public double norm1() {
        long rows = this.getRowCount();
        long cols = this.getColumnCount();
        double max = 0.0;
        long c = 0L;
        while (c < cols) {
            double sum = 0.0;
            long r = 0L;
            while (r < rows) {
                sum += Math.abs(this.getAsDouble(r++, c));
            }
            max = Math.max(max, sum);
            ++c;
        }
        return max;
    }

    @Override
    public double norm2() {
        return this.svd()[1].getAsDouble(0L, 0L);
    }

    @Override
    public double normInf() {
        long rows = this.getRowCount();
        long cols = this.getColumnCount();
        double max = 0.0;
        long r = 0L;
        while (r < rows) {
            double sum = 0.0;
            long c = 0L;
            while (c < cols) {
                sum += Math.abs(this.getAsDouble(r, c++));
            }
            max = Math.max(max, sum);
            ++r;
        }
        return max;
    }

    @Override
    public double normF() {
        long rows = this.getRowCount();
        long cols = this.getColumnCount();
        double result = 0.0;
        long ro = 0L;
        while (ro < rows) {
            long c = 0L;
            while (c < cols) {
                double b = this.getAsDouble(ro, c);
                double temp = 0.0;
                if (Math.abs(result) > Math.abs(b)) {
                    temp = b / result;
                    temp = Math.abs(result) * Math.sqrt(1.0 + temp * temp);
                } else if (b != 0.0) {
                    temp = result / b;
                    temp = Math.abs(b) * Math.sqrt(1.0 + temp * temp);
                } else {
                    temp = 0.0;
                }
                result = temp;
                ++c;
            }
            ++ro;
        }
        return result;
    }

    @Override
    public ListMatrix<?> toListMatrix() {
        if (this instanceof ListMatrix) {
            return (ListMatrix)((Object)this);
        }
        DefaultListMatrix list = new DefaultListMatrix();
        int row = 0;
        while ((long)row < this.getRowCount()) {
            list.add(this.getAsObject(row, 0L));
            ++row;
        }
        return list;
    }

    @Override
    public SetMatrix<?> toSetMatrix() {
        if (this instanceof SetMatrix) {
            return (SetMatrix)((Object)this);
        }
        DefaultSetMatrix set = new DefaultSetMatrix();
        int row = 0;
        while ((long)row < this.getRowCount()) {
            set.add(this.getAsObject(row, 0L));
            ++row;
        }
        return set;
    }

    @Override
    public MapMatrix<?, ?> toMapMatrix() {
        if (this instanceof MapMatrix) {
            return (MapMatrix)((Object)this);
        }
        DefaultMapMatrix<Object, Object> map = new DefaultMapMatrix<Object, Object>();
        int row = 0;
        while ((long)row < this.getRowCount()) {
            map.put(this.getAsObject(row, 0L), this.getAsObject(row, 1L));
            ++row;
        }
        return map;
    }

    @Override
    public final boolean isSparse() {
        switch (this.getStorageType()) {
            case DENSE: {
                return false;
            }
            case SET: {
                return false;
            }
            case TREE: {
                return true;
            }
            case MAP: {
                return false;
            }
            case LIST: {
                return false;
            }
            case SPARSE: {
                return true;
            }
            case GRAPH: {
                return true;
            }
        }
        throw new MatrixException("unknown storage type: " + (Object)((Object)this.getStorageType()));
    }

    @Override
    public boolean containsBigInteger(BigInteger v) {
        for (long[] c : this.availableCoordinates()) {
            if (!v.equals(this.getAsBigInteger(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBigDecimal(BigDecimal v) {
        for (long[] c : this.availableCoordinates()) {
            if (!v.equals(this.getAsBigDecimal(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDate(Date v) {
        for (long[] c : this.availableCoordinates()) {
            if (!v.equals(this.getAsDate(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsObject(Object o) {
        for (long[] c : this.availableCoordinates()) {
            if (!o.equals(this.getAsObject(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsString(String s) {
        for (long[] c : this.availableCoordinates()) {
            if (!s.equals(this.getAsString(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBoolean(boolean v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsBoolean(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsByte(byte v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsByte(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChar(char v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsChar(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDouble(double v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsDouble(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsFloat(float v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsFloat(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInt(int v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsInt(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsLong(long v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsLong(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsShort(short v) {
        for (long[] c : this.availableCoordinates()) {
            if (this.getAsShort(c) != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNull() {
        for (long[] c : this.allCoordinates()) {
            if (this.getAsDouble(c) != 0.0) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatrixFactoryRoot getFactory() {
        return factory;
    }
}

