/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc;

import org.ujmp.core.enums.DB;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.jdbc.AbstractDenseJDBCMatrix2D;
import org.ujmp.jdbc.DenseDerbyMatrix2D;
import org.ujmp.jdbc.DenseHSQLDBMatrix2D;
import org.ujmp.jdbc.DenseMySQLMatrix2D;
import org.ujmp.jdbc.DensePostgreSQLMatrix2D;

public class LinkMatrixJDBC {
    public static AbstractDenseJDBCMatrix2D toDatabase(String url, String sqlStatement, String username, String password) throws Exception {
        if (url.startsWith("jdbc:mysql://")) {
            return new DenseMySQLMatrix2D(url, sqlStatement, username, password);
        }
        if (url.startsWith("jdbc:postgresql://")) {
            return new DensePostgreSQLMatrix2D(url, sqlStatement, username, password);
        }
        if (url.startsWith("jdbc:derby://")) {
            return new DenseDerbyMatrix2D(url, sqlStatement, username, password);
        }
        if (url.startsWith("jdbc:hsqldb://")) {
            return new DenseHSQLDBMatrix2D(url, sqlStatement, username, password);
        }
        throw new MatrixException("Database format not supported: " + url);
    }

    public static AbstractDenseJDBCMatrix2D toDatabase(DB type, String host, int port, String databasename, String sqlStatement, String username, String password) throws Exception {
        switch (type) {
            case MySQL: {
                return LinkMatrixJDBC.toDatabase("jdbc:mysql://" + host + ":" + port + "/" + databasename, sqlStatement, username, password);
            }
            case PostgreSQL: {
                return LinkMatrixJDBC.toDatabase("jdbc:postgresql://" + host + ":" + port + "/" + databasename, sqlStatement, username, password);
            }
            case Derby: {
                return LinkMatrixJDBC.toDatabase("jdbc:derby://" + host + ":" + port + "/" + databasename, sqlStatement, username, password);
            }
            case HSQLDB: {
                return LinkMatrixJDBC.toDatabase("jdbc:hsqldb://" + host + ":" + port + "/" + databasename, sqlStatement, username, password);
            }
        }
        throw new MatrixException("Database type unknown: " + (Object)((Object)type));
    }
}

