/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.evaluator;

import adams.core.Utils;
import adams.data.weka.evaluator.AbstractCrossvalidatedInstanceEvaluator;
import java.util.Collections;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.GaussianProcesses;
import weka.core.Instance;
import weka.core.Instances;

public class IntervalEstimatorBased
extends AbstractCrossvalidatedInstanceEvaluator<SortedInterval> {
    private static final long serialVersionUID = -7760097633698319552L;
    protected Classifier m_Classifier;
    protected double m_ConfidenceLevel;
    protected boolean m_RelativeWidths;
    protected double m_MaxWidth;
    protected double m_MinWidth;

    public String globalInfo() {
        return "Uses a classifier that produces confidence intervals. ???";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new GaussianProcesses());
        this.m_OptionManager.add("level", "confidenceLevel", (Object)0.95);
        this.m_OptionManager.add("relative", "relativeWidths", (Object)false);
    }

    public void setClassifier(Classifier value) {
        if (value instanceof IntervalEstimator) {
            this.m_Classifier = value;
            this.reset();
        } else {
            this.getSystemErr().println("Classifier must implement " + IntervalEstimator.class.getName());
        }
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use (must implement " + IntervalEstimator.class.getName() + ").";
    }

    public void setConfidenceLevel(double value) {
        this.m_ConfidenceLevel = value;
        this.reset();
    }

    public double getConfidenceLevel() {
        return this.m_ConfidenceLevel;
    }

    public String confidenceLevelTipText() {
        return "The confidence level to use when generating the confidence intervals (0-1).";
    }

    public void setRelativeWidths(boolean value) {
        this.m_RelativeWidths = value;
        this.reset();
    }

    public boolean getRelativeWidths() {
        return this.m_RelativeWidths;
    }

    public String relativeWidthsTipText() {
        return "If set to true, then the calculated widths will be relative ones, as they will get divided by the class value of the Instance.";
    }

    @Override
    protected String findThreshold(Vector<SortedInterval> evals) {
        if (evals.size() == 0) {
            return "No intervals collected!";
        }
        Collections.sort(evals);
        this.m_MinWidth = evals.firstElement().getAverageWidth();
        int location = (int)Math.round((double)evals.size() * this.m_Threshold);
        this.m_MaxWidth = evals.get(location).getAverageWidth();
        if (this.isDebugOn()) {
            this.debug("Computed thresholds: min=" + this.m_MinWidth + ", max=" + this.m_MaxWidth);
        }
        return null;
    }

    @Override
    protected Vector<SortedInterval> evaluate(Instances train, Instances test) {
        Vector<SortedInterval> result = new Vector<SortedInterval>();
        try {
            if (this.isDebugOn()) {
                this.debug("Building classifier...");
            }
            this.m_Classifier.buildClassifier(train);
            if (this.isDebugOn()) {
                this.debug("Obtaining intervals...");
            }
            for (int i = 0; i < test.numInstances(); ++i) {
                try {
                    result.add(new SortedInterval(test.instance(i), ((IntervalEstimator)this.m_Classifier).predictIntervals(test.instance(i), this.m_ConfidenceLevel), this.m_RelativeWidths));
                    continue;
                }
                catch (Exception e) {
                    this.getSystemErr().println("Error obtaining intervals for test instance #" + (i + 1) + ": " + test.instance(i));
                    this.getSystemErr().printStackTrace((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    @Override
    protected double doEvaluate(Instance inst) {
        double result;
        try {
            double[][] intervals = ((IntervalEstimator)this.m_Classifier).predictIntervals(inst, this.m_ConfidenceLevel);
            double width = IntervalEstimatorBased.calcAverageWidth(intervals);
            if (this.m_RelativeWidths) {
                width = inst.classValue() == 0.0 ? Double.MAX_VALUE : (width /= inst.classValue());
            }
            result = width < this.m_MinWidth ? 1.0 : (width > this.m_MaxWidth ? ((width -= this.m_MaxWidth) > this.m_MaxWidth ? 0.0 : 0.5 - width / this.m_MaxWidth / 2.0) : 1.0 - (width - this.m_MinWidth) / (this.m_MaxWidth - this.m_MinWidth) / 2.0);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            result = -1.0;
        }
        return result;
    }

    protected static double calcWidth(double[] array) {
        return array[1] - array[0];
    }

    protected static double calcAverageWidth(double[][] array) {
        double result = 0.0;
        for (int i = 0; i < array.length; ++i) {
            result += IntervalEstimatorBased.calcWidth(array[i]);
        }
        if (array.length > 0) {
            result /= (double)array.length;
        }
        return result;
    }

    public static class SortedInterval
    extends AbstractCrossvalidatedInstanceEvaluator.EvaluationContainer {
        protected double[][] m_Intervals;
        protected double m_AverageWidth;
        protected boolean m_RelativeWidths;

        public SortedInterval(Instance inst, double[][] intervals, boolean relative) {
            super(inst);
            this.m_Intervals = (double[][])intervals.clone();
            this.m_AverageWidth = IntervalEstimatorBased.calcAverageWidth(this.m_Intervals);
            this.m_RelativeWidths = relative;
            if (this.m_RelativeWidths) {
                this.m_AverageWidth = this.m_Instance.classValue() == 0.0 ? Double.MAX_VALUE : (this.m_AverageWidth /= this.m_Instance.classValue());
            }
        }

        public double[][] getIntervals() {
            return this.m_Intervals;
        }

        public double getAverageWidth() {
            return this.m_AverageWidth;
        }

        @Override
        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            SortedInterval other = (SortedInterval)o;
            int result = new Integer(this.getIntervals().length).compareTo(new Integer(other.getIntervals().length));
            if (result == 0) {
                double widthOther;
                double width;
                for (int i = 0; i < this.m_Intervals.length && (result = new Double(width = IntervalEstimatorBased.calcWidth(this.getIntervals()[i])).compareTo(new Double(widthOther = IntervalEstimatorBased.calcWidth(other.getIntervals()[i])))) == 0; ++i) {
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return "intervals=" + Utils.arrayToString((Object)this.m_Intervals) + ", avg width=" + this.m_AverageWidth;
        }
    }
}

